/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.client;

import ch.inftec.ju.ee.client.ModifierTestProducer;
import ch.inftec.ju.ee.client.ServiceLocator;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ServiceLocatorTest {
    @Inject
    private BeanManager beanManager;
    @Inject
    @Named(value="named")
    private ModifierTestProducer.TestObject namedObject;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ModifierTestProducer.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void canInject_namedObject() {
        Assert.assertEquals((Object)"named", (Object)this.namedObject.getValue());
    }

    @Test
    public void canLookup_namedObject() {
        Assert.assertEquals((Object)"named", (Object)((ModifierTestProducer.TestObject)this.local().cdiNamed(ModifierTestProducer.TestObject.class, "named")).getValue());
    }

    @Test
    public void canLookup_complexBeans() {
        ModifierTestProducer.TestObject to = (ModifierTestProducer.TestObject)this.local().cdiComplex(ModifierTestProducer.TestObject.class).named("namedScope").scopeControl().find().one();
        Assert.assertEquals((Object)"namedWithScopeControl", (Object)to.getValue());
    }

    @Test
    public void canLookup_complexBeans_scopeControlAnnotated() {
        int cnt = this.local().cdiComplex(ModifierTestProducer.TestObject.class).scopeControl().find().all().size();
        Assert.assertEquals((long)2L, (long)cnt);
    }

    private ServiceLocator local() {
        return ServiceLocatorBuilder.createLocalByBeanManager((BeanManager)this.beanManager);
    }
}

