/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.ee.client.JndiServiceLocator;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import ch.inftec.ju.ee.test.TestRunnerAnnotationHandler;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import ch.inftec.ju.util.TestUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.ejb.EJBException;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ContainerTestRunnerRule
implements TestRule {
    private final TestRunnerType type;

    public ContainerTestRunnerRule(TestRunnerType type) {
        this.type = type;
    }

    public Statement apply(Statement base, Description description) {
        Method method = TestUtils.getTestMethod((Description)description);
        Object testStatement = null;
        if (this.type == TestRunnerType.CONTAINER) {
            ContainerTestRunnerStatement containerTestRunnerStatement = new ContainerTestRunnerStatement(method, description);
            Test t = method.getAnnotation(Test.class);
            testStatement = t != null && t.expected() != Test.None.class ? new ExpectException((Statement)containerTestRunnerStatement, t.expected()) : containerTestRunnerStatement;
        } else {
            testStatement = base;
        }
        return new ContainerPreAndPostRunnerStatement(method, description, (Statement)testStatement);
    }

    private static class ContainerPreAndPostRunnerStatement
    extends ContainerRunnerStatement {
        private final Statement testStatement;

        private ContainerPreAndPostRunnerStatement(Method method, Description description, Statement testStatement) {
            super(method, description);
            this.testStatement = testStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doEvaluation(TestRunnerFacade facade, TestRunnerFacade.TestRunnerContext context) throws Throwable {
            TestRunnerAnnotationHandler handler = new TestRunnerAnnotationHandler(this.method, this.description, context);
            SystemPropertyTempSetter tempSetter = facade.runPreTestActionsInEjbContext(handler);
            try {
                this.testStatement.evaluate();
                facade.runPostTestActionsInEjbContext(handler);
            }
            finally {
                facade.resetSystemProperties(tempSetter);
            }
        }
    }

    private static class ContainerTestRunnerStatement
    extends ContainerRunnerStatement {
        private ContainerTestRunnerStatement(Method method, Description description) {
            super(method, description);
        }

        @Override
        protected void doEvaluation(TestRunnerFacade facade, TestRunnerFacade.TestRunnerContext context) throws Throwable {
            facade.runTestMethodInEjbContext(new TestRunnerAnnotationHandler(this.method, this.description, context));
        }
    }

    private static abstract class ContainerRunnerStatement
    extends Statement {
        protected final Method method;
        protected final Description description;

        private ContainerRunnerStatement(Method method, Description description) {
            this.method = method;
            this.description = description;
        }

        public void evaluate() throws Throwable {
            try {
                TestRunnerFacade.TestRunnerContext context = new TestRunnerFacade.TestRunnerContext();
                Path localRoot = Paths.get(".", new String[0]).toAbsolutePath();
                context.setLocalRoot(localRoot.toString());
                JndiServiceLocator serviceLocator = ServiceLocatorBuilder.createRemoteByConfigurationFiles();
                TestRunnerFacade testRunnerFacade = serviceLocator.lookup(TestRunnerFacade.class);
                this.doEvaluation(testRunnerFacade, context);
            }
            catch (Throwable t) {
                throw this.getActualThrowable(t);
            }
        }

        protected abstract void doEvaluation(TestRunnerFacade var1, TestRunnerFacade.TestRunnerContext var2) throws Throwable;

        private Throwable getActualThrowable(Throwable t) {
            if (t instanceof InvocationTargetException) {
                return t.getCause();
            }
            if (t instanceof EJBException) {
                if (t.getCause() != null && t.getCause().getClass() == RuntimeException.class) {
                    return t.getCause().getCause();
                }
                return t.getCause();
            }
            if (t instanceof ExceptionInInitializerError) {
                throw new IllegalStateException("Looks like we couldn't connect to JBoss. Make sure it is running.", t);
            }
            if (t.getCause() instanceof ComparisonFailure) {
                return t.getCause();
            }
            return t;
        }
    }

    public static enum TestRunnerType {
        CONTAINER,
        REMOTE_TEST;

    }
}

