/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.db.TxHandler;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import ch.inftec.ju.ee.test.ContainerTestContext;
import ch.inftec.ju.ee.test.DataVerifierCdi;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.testing.db.DataVerifier;
import ch.inftec.ju.testing.db.DbTestAnnotationHandler;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.UUID;
import org.junit.runner.Description;

class TestRunnerAnnotationHandler
extends DbTestAnnotationHandler
implements Serializable {
    private final TestRunnerFacade.TestRunnerContext context;

    TestRunnerAnnotationHandler(Method method, Description description, TestRunnerFacade.TestRunnerContext context) {
        super(method, description);
        this.context = context;
    }

    TestRunnerFacade.TestRunnerContext getContext() {
        return this.context;
    }

    UUID getUuid() {
        return this.getContext() != null ? this.getContext().getUuid() : null;
    }

    protected String getLocalRoot() {
        return this.getContext().getLocalRoot();
    }

    private void initTestClass(Object instance, TxHandler txHandler) {
        if (TestRunnerFacade.ContextAware.class.isAssignableFrom(instance.getClass())) {
            ((TestRunnerFacade.ContextAware)instance).setContext(this.getContext());
        }
        if (TestRunnerFacade.TransactionAware.class.isAssignableFrom(instance.getClass())) {
            ((TestRunnerFacade.TransactionAware)instance).setTxHandler(txHandler);
        }
        if (TestRunnerFacade.Initializable.class.isAssignableFrom(instance.getClass())) {
            ((TestRunnerFacade.Initializable)instance).init();
        }
    }

    protected void initVerifier(DataVerifier verifier) {
        if (verifier instanceof DataVerifierCdi) {
            ((DataVerifierCdi)verifier).init(ServiceLocatorBuilder.buildLocal().createServiceLocator());
        }
    }

    public final void executeTestMethod(TxHandler txHandler) throws Exception {
        Class<?> clazz = Class.forName(this.testClassName);
        Object instance = clazz.newInstance();
        Method method = clazz.getMethod(this.testMethodName, new Class[0]);
        this.initTestClass(instance, txHandler);
        try {
            method.invoke(instance, new Object[0]);
        }
        catch (Exception ex) {
            this.handleServerThrowable(ex);
        }
    }

    class ContainerTestContextSetter
    implements AutoCloseable {
        boolean disposeContext = false;

        public ContainerTestContextSetter() {
            ContainerTestContext.startContext(TestRunnerAnnotationHandler.this.getContext() != null ? TestRunnerAnnotationHandler.this.getContext().getUuid() : null);
        }

        public ContainerTestContextSetter(boolean disposeContext) {
            this();
            this.disposeContext = disposeContext;
        }

        @Override
        public void close() {
            ContainerTestContext.endContext(this.disposeContext);
        }
    }
}

