/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.client;

import ch.inftec.ju.ee.client.ModifierTestProducer;
import ch.inftec.ju.ee.client.ServiceLocator;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import ch.inftec.ju.util.JuUrl;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.List;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ServiceLocatorTest {
    @Inject
    private BeanManager beanManager;
    @Inject
    @Named(value="named")
    private ModifierTestProducer.TestObject namedObject;

    @Deployment
    public static JavaArchive createDeployment() {
        URL beansXml = JuUrl.existingResourceRelativeTo((String)"beans.xml", ServiceLocatorTest.class);
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ModifierTestProducer.class)).addAsManifestResource(beansXml, "beans.xml");
    }

    @Test
    public void canInject_namedObject() {
        Assert.assertEquals((Object)"named", (Object)this.namedObject.getValue());
    }

    @Test
    public void canLookup_namedObject() {
        Assert.assertEquals((Object)"named", (Object)((ModifierTestProducer.TestObject)this.local().cdiNamed(ModifierTestProducer.TestObject.class, "named")).getValue());
    }

    @Test
    public void canLookup_complexBeans() {
        ModifierTestProducer.TestObject to = (ModifierTestProducer.TestObject)this.local().cdiComplex(ModifierTestProducer.TestObject.class).named("namedScope").scopeControl().find().one();
        Assert.assertEquals((Object)"namedWithScopeControl", (Object)to.getValue());
    }

    @Test
    public void canLookup_complexBeans_scopeControlAnnotated() {
        int cnt = this.local().cdiComplex(ModifierTestProducer.TestObject.class).scopeControl().find().all().size();
        Assert.assertEquals((long)2L, (long)cnt);
    }

    @Test
    public void cdi_resolvesAlternateBean() {
        Alt alt = (Alt)this.local().cdi(Alt.class);
        Assert.assertEquals((Object)"AltAlternative", (Object)alt.getVal());
    }

    @Test
    public void cdi_withoutMatch_returnsNull() {
        Assert.assertNull((Object)this.local().cdi(String.class));
    }

    @Test
    public void cdiAll_includesAlternateBeans() {
        List alts = this.local().cdiAll(Alt.class);
        Assert.assertEquals((long)2L, (long)alts.size());
    }

    @Test
    public void cdiAll_resolvesMultipleBeans_withoutQualifier() {
        List multis = this.local().cdiAll(Multi.class);
        Assert.assertEquals((long)2L, (long)multis.size());
    }

    @Test
    public void cdiAnno_resolvesAnnotatedBean() {
        Multi multi = (Multi)this.local().cdiAnno(Multi.class, new Annotation[]{new SpecialAnno()});
        Assert.assertEquals(Multi3.class, multi.getClass());
    }

    @Test
    public void cdiAllAnno_resolvesAll_withAnyQualifier() {
        List multis = this.local().cdiAllAnno(Multi.class, new Annotation[]{ServiceLocator.ANY});
        Assert.assertEquals((long)3L, (long)multis.size());
    }

    @Test
    public void cdiAllAnno_resolvesAnnotatedBean() {
        List multis = this.local().cdiAllAnno(Multi.class, new Annotation[]{new SpecialAnno()});
        Assert.assertEquals((long)1L, (long)multis.size());
        Assert.assertEquals(Multi3.class, ((Multi)multis.get(0)).getClass());
    }

    private ServiceLocator local() {
        return ServiceLocatorBuilder.createLocalByBeanManager((BeanManager)this.beanManager);
    }

    @Special
    public static class Multi3
    implements Multi {
    }

    static class SpecialAnno
    implements Annotation,
    Special {
        SpecialAnno() {
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Special.class;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    public static @interface Special {
    }

    public static class Multi2
    implements Multi {
    }

    public static class Multi1
    implements Multi {
    }

    public static interface Multi {
    }

    @Alternative
    public static class AltAlternative
    implements Alt {
        @Override
        public String getVal() {
            return "AltAlternative";
        }
    }

    public static class AltDefault
    implements Alt {
        @Override
        public String getVal() {
            return "AltDefault";
        }
    }

    public static interface Alt {
        public String getVal();
    }
}

