/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.client;

import ch.inftec.ju.ee.client.JndiServiceLocator;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import ch.inftec.ju.ee.test.TestRemote;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Needs running JBoss")
public class RemoteServiceLocatorTest {
    @Test
    public void canLookup_testFacadeBean_usingEjbClientApi() throws Exception {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        InitialContext context = new InitialContext(jndiProperties);
        TestRemote testRemote = (TestRemote)context.lookup("ejb:ee-ear-ear/ee-ear-ejb/TestRemoteBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to EjbClientApi", (Object)testRemote.getGreeting("EjbClientApi"));
    }

    @Test
    public void canLookup_testFacadeBean_usingEjbClientApi_withoutFile() throws Exception {
        Properties clientProp = new Properties();
        clientProp.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
        clientProp.put("remote.connections", "default");
        clientProp.put("remote.connection.default.port", "14447");
        clientProp.put("remote.connection.default.host", "localhost");
        clientProp.put("remote.connection.default.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS", "false");
        PropertiesBasedEJBClientConfiguration cc = new PropertiesBasedEJBClientConfiguration(clientProp);
        ConfigBasedEJBClientContextSelector selector = new ConfigBasedEJBClientContextSelector((EJBClientConfiguration)cc);
        EJBClientContext.setSelector((ContextSelector)selector);
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        InitialContext context = new InitialContext(jndiProperties);
        TestRemote testRemote = (TestRemote)context.lookup("ejb:ee-ear-ear/ee-ear-ejb/TestRemoteBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to EjbClientApi", (Object)testRemote.getGreeting("EjbClientApi"));
    }

    @Test
    public void canLookup_testFacadeBean_usingRemoteNaming() throws Exception {
        Properties jndiProps = new Properties();
        jndiProps.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        jndiProps.put("java.naming.provider.url", "remote://localhost:14447");
        jndiProps.put("remote.connection.default.port", "14447");
        InitialContext ctx = new InitialContext(jndiProps);
        TestRemote testRemote = (TestRemote)ctx.lookup("ee-ear-ear/ee-ear-ejb/TestRemoteBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to RemoteNamingWithoutPrefix", (Object)testRemote.getGreeting("RemoteNamingWithoutPrefix"));
        testRemote = (TestRemote)ctx.lookup("java:ee-ear-ear/ee-ear-ejb/TestRemoteBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to RemoteNaming", (Object)testRemote.getGreeting("RemoteNaming"));
    }

    @Ignore(value="Will fail with exception as bli doesn't exist")
    @Test
    public void canLookup_testRunnerFacadeBean_usingRemoteNaming() throws Exception {
        Properties jndiProps = new Properties();
        jndiProps.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        jndiProps.put("java.naming.provider.url", "remote://localhost:14447");
        InitialContext ctx = new InitialContext(jndiProps);
        TestRunnerFacade testRunnerFacade = (TestRunnerFacade)ctx.lookup("ee-ear-ear/ee-ear-ejb/TestRunnerFacadeBean!" + TestRunnerFacade.class.getName());
    }

    @Test
    public void canLookup_testFacadeBean_usingServiceLocatorBuilder() throws Exception {
        JndiServiceLocator loc = ServiceLocatorBuilder.buildRemote().remoteServer("localhost", 14447).appName("ee-ear-ear").moduleName("ee-ear-ejb").createServiceLocator();
        TestRemote testRemote = (TestRemote)loc.lookup(TestRemote.class);
        Assert.assertEquals((Object)"TestRemoteBean says hello to ServiceLocatorBuilder", (Object)testRemote.getGreeting("ServiceLocatorBuilder"));
    }

    @Ignore(value="Will fail with exception as bli doesn't exist")
    @Test
    public void canLookup_testRunnerFacadeBean_usingServiceLocatorBuilder() throws Exception {
        JndiServiceLocator loc = ServiceLocatorBuilder.buildRemote().remoteServer("localhost", 14447).appName("ee-ear-ear").moduleName("ee-ear-ejb").createServiceLocator();
        TestRunnerFacade testRunnerFacade = (TestRunnerFacade)loc.lookup(TestRunnerFacade.class);
    }
}

