/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.TxHandler;
import ch.inftec.ju.ee.test.TestRunnerAnnotationHandler;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import java.lang.reflect.Method;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;

@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestRunnerFacadeBean
implements TestRunnerFacade {
    private static Logger logger = Logger.getLogger(TestRunnerFacadeBean.class);
    @Inject
    private UserTransaction tx;
    @Inject
    private EntityManager em;

    @Override
    public SystemPropertyTempSetter runPreTestActionsInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        try (TestRunnerAnnotationHandler.ContainerTestContextSetter s = new TestRunnerAnnotationHandler.ContainerTestContextSetter(handler);){
            SystemPropertyTempSetter tempSetter = handler.initContainerTestEnv();
            try (TxHandler txHandler = new TxHandler(this.tx, true);){
                handler.executePreTestAnnotations(new JuEmUtil(this.em));
                txHandler.commit();
            }
            catch (Exception ex) {
                tempSetter.close();
                throw ex;
            }
            SystemPropertyTempSetter systemPropertyTempSetter = tempSetter;
            return systemPropertyTempSetter;
        }
    }

    @Override
    public void runTestMethodInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        try (TestRunnerAnnotationHandler.ContainerTestContextSetter s = new TestRunnerAnnotationHandler.ContainerTestContextSetter(handler);
             TxHandler txHandler = new TxHandler(this.tx, true);){
            logger.debug((Object)String.format("Running Test %s", handler));
            handler.executeTestMethod(txHandler);
            txHandler.commit();
        }
    }

    @Override
    public void runPostTestActionsInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        try (TestRunnerAnnotationHandler.ContainerTestContextSetter s = new TestRunnerAnnotationHandler.ContainerTestContextSetter(handler);){
            try (TxHandler txHandler = new TxHandler(this.tx, true);){
                handler.executePostServerCode(new JuEmUtil(this.em));
                txHandler.commit();
            }
            txHandler = new TxHandler(this.tx, true);
            var5_7 = null;
            try {
                handler.executePostTestAnnotations(new JuEmUtil(this.em));
                txHandler.commit();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (txHandler != null) {
                    if (var5_7 != null) {
                        try {
                            txHandler.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        txHandler.close();
                    }
                }
            }
        }
    }

    @Override
    public Object runMethodInEjbContext(String className, String methodName, Class<?>[] argumentTypes, Object[] args) throws Exception {
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, argumentTypes);
            Object res = method.invoke(instance, args);
            txHandler.commit();
            Object object = res;
            return object;
        }
    }

    @Override
    public void cleanupTestRun(TestRunnerAnnotationHandler handler, SystemPropertyTempSetter tempSetter) {
        TestRunnerAnnotationHandler testRunnerAnnotationHandler = handler;
        testRunnerAnnotationHandler.getClass();
        try (TestRunnerAnnotationHandler.ContainerTestContextSetter s = new TestRunnerAnnotationHandler.ContainerTestContextSetter(testRunnerAnnotationHandler, true);){
            tempSetter.close();
            if (((Boolean)JuUtils.getJuPropertyChain().get("ju-testing-ee.clearPropertyChainAfterEachTest", Boolean.class, "false")).booleanValue()) {
                JuUtils.clearPropertyChain();
            }
        }
    }

    @Override
    public String getVersion() {
        return "1";
    }
}

