/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.ee.test.ContainerTestScoped;
import ch.inftec.ju.util.JuRuntimeException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTestContext
implements Context {
    private static Logger logger = LoggerFactory.getLogger(ContainerTestContext.class);
    private static ThreadLocal<UUID> contextUuid = new ThreadLocal();
    private static Set<UUID> activeContexts = new HashSet<UUID>();
    private static Map<UUID, Map<Class<?>, CustomScopeInstance<?>>> allInstances = new HashMap();

    private static synchronized Object getObject(Class<?> clazz) {
        if (contextUuid.get() != null && allInstances.containsKey(contextUuid.get())) {
            return ContainerTestContext.allInstances.get((Object)ContainerTestContext.contextUuid.get()).get(clazz).instance;
        }
        return null;
    }

    private static synchronized <T> T storeObject(Class<?> clazz, CustomScopeInstance<T> inst) {
        if (contextUuid.get() != null) {
            if (!allInstances.containsKey(contextUuid.get())) {
                allInstances.put(contextUuid.get(), new HashMap());
            }
            allInstances.get(contextUuid.get()).put(clazz, inst);
            return inst.instance;
        }
        throw new JuRuntimeException("No active context");
    }

    static synchronized void startContext(UUID uuid) {
        logger.debug("Starting context: " + uuid);
        contextUuid.set(uuid);
        activeContexts.add(uuid);
    }

    static synchronized <T> void endContext(boolean dispose) {
        UUID id = contextUuid.get();
        logger.debug("Ending context [dispose={}]: {}", (Object)dispose, (Object)id);
        contextUuid.set(null);
        activeContexts.remove(id);
        if (dispose && id != null && allInstances.containsKey(id)) {
            for (CustomScopeInstance<?> inst : allInstances.get(id).values()) {
                inst.destroy();
            }
            allInstances.remove(id);
        }
    }

    public Class<? extends Annotation> getScope() {
        return ContainerTestScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T t = this.get(contextual);
        if (t == null) {
            Bean b = (Bean)contextual;
            return ContainerTestContext.storeObject(b.getBeanClass(), new CustomScopeInstance<T>(b, creationalContext));
        }
        return t;
    }

    public <T> T get(Contextual<T> contextual) {
        Bean b = (Bean)contextual;
        Object t = ContainerTestContext.getObject(b.getBeanClass());
        return (T)t;
    }

    public boolean isActive() {
        return ContainerTestContext.isContextActive();
    }

    public static synchronized boolean isContextActive() {
        UUID id = contextUuid.get();
        return id != null && activeContexts.contains(id);
    }

    public static class CustomScopeInstance<T> {
        final Bean<T> bean;
        final CreationalContext<T> ctx;
        final T instance;

        public CustomScopeInstance(Bean<T> bean, CreationalContext<T> ctx) {
            this.bean = bean;
            this.ctx = ctx;
            this.instance = bean.create(this.ctx);
        }

        public void destroy() {
            this.bean.destroy(this.instance, this.ctx);
        }
    }
}

