/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.client;

import ch.inftec.ju.ee.client.JndiServiceLocator;
import ch.inftec.ju.ee.client.ServiceLocator;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.PropertyChain;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLocatorBuilder {
    public static RemoteServiceLocatorBuilder buildRemote() {
        return new RemoteServiceLocatorBuilder();
    }

    public static JndiServiceLocator createRemoteByConfigurationFiles() {
        PropertyChain pc = JuUtils.getJuPropertyChain();
        Integer port = (Integer)pc.get("ju-util-ee.remote.port", Integer.class, true);
        Integer portOffset = (Integer)pc.get("ju-util-ee.portOffset", Integer.class, true);
        return ServiceLocatorBuilder.buildRemote().remoteServer(pc.get("ju-util-ee.remote.host", true), port + portOffset).appName(pc.get("ju-util-ee.remote.appName", true)).moduleName(pc.get("ju-util-ee.remote.moduleName", true)).createServiceLocator();
    }

    public static LocalServiceLocatorBuilder buildLocal() {
        return new LocalServiceLocatorBuilder();
    }

    private static class LocalServiceLocatorImpl
    extends AbstractJndiServiceLocator
    implements ServiceLocator {
        private static final String JNDI_NAME_BEAN_MANAGER = "java:comp/BeanManager";
        private final String moduleName;
        private BeanManager bm;

        private LocalServiceLocatorImpl(String moduleName) {
            super(LocalServiceLocatorImpl.createInitialContext());
            this.moduleName = moduleName == null ? "" : moduleName;
            this.bm = (BeanManager)this.lookup(JNDI_NAME_BEAN_MANAGER);
        }

        private static Context createInitialContext() {
            try {
                return new InitialContext();
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't create InitialContext", (Throwable)ex);
            }
        }

        @Override
        public <T> T lookup(Class<T> clazz) {
            String jndiName = String.format("java:app/%s/%s!%s", this.moduleName, clazz.getSimpleName() + "Bean", clazz.getName());
            return this.lookup(jndiName);
        }

        @Override
        public <T> T cdi(Class<T> clazz) {
            Set beans = this.bm.getBeans(clazz, new Annotation[0]);
            List<T> instances = this.getInstances(beans, clazz);
            if (instances.size() != 1) {
                throw new JuRuntimeException("Expected exactly one result for CDI lookup of %s, but found %d", new Object[]{clazz, instances.size()});
            }
            return instances.get(0);
        }

        private <T> List<T> getInstances(Set<Bean<?>> beans, Class<T> clazz) {
            ArrayList<Object> instances = new ArrayList<Object>();
            for (Bean<?> bean : beans) {
                CreationalContext cont = this.bm.createCreationalContext(bean);
                Object t = this.bm.getReference(bean, clazz, cont);
                instances.add(t);
            }
            return instances;
        }
    }

    private static class RemoteServiceLocatorImpl
    extends AbstractJndiServiceLocator {
        private final String appName;
        private final String moduleName;

        public RemoteServiceLocatorImpl(Context ctx, String appName, String moduleName) {
            super(ctx);
            this.appName = appName;
            this.moduleName = moduleName;
        }

        @Override
        protected String getAbsoluteJndiName(String jndiName) {
            String absoluteJndiName = String.format("ejb:%s/%s/%s", this.appName, this.moduleName, jndiName);
            return absoluteJndiName;
        }

        @Override
        public <T> T lookup(Class<T> clazz) {
            String lookupString = String.format("%sBean!%s", clazz.getSimpleName(), clazz.getName());
            return this.lookup(lookupString);
        }
    }

    private static abstract class AbstractJndiServiceLocator
    implements JndiServiceLocator {
        protected Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Context ctx;

        protected AbstractJndiServiceLocator(Context ctx) {
            this.ctx = ctx;
        }

        protected String getAbsoluteJndiName(String jndiName) {
            return jndiName;
        }

        @Override
        public <T> T lookup(String jndiName) {
            String absoluteJndiName = this.getAbsoluteJndiName(jndiName);
            this.logger.debug(String.format("JNDI lookup (relative: %s, absolute: %s)", jndiName, absoluteJndiName));
            try {
                Object obj = this.ctx.lookup(absoluteJndiName);
                return (T)obj;
            }
            catch (Exception ex) {
                throw new JuRuntimeException((Throwable)ex);
            }
        }
    }

    public static class LocalServiceLocatorBuilder {
        private String moduleName;

        public LocalServiceLocatorBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public ServiceLocator createServiceLocator() {
            return new LocalServiceLocatorImpl(this.moduleName);
        }
    }

    public static class RemoteServiceLocatorBuilder {
        private Logger logger = LoggerFactory.getLogger(RemoteServiceLocatorBuilder.class);
        private String host = "localhost";
        private int port = 4447;
        private String appName;
        private String moduleName;

        public RemoteServiceLocatorBuilder initByConfigurationFiles() {
            PropertyChain pc = JuUtils.getJuPropertyChain();
            Integer port = (Integer)pc.get("ju-util-ee.remote.port", Integer.class, true);
            Integer portOffset = (Integer)pc.get("ju-util-ee.portOffset", Integer.class, true);
            this.remoteServer(pc.get("ju-util-ee.remote.host", true), port + portOffset);
            this.appName(pc.get("ju-util-ee.remote.appName", true));
            this.moduleName(pc.get("ju-util-ee.remote.moduleName", true));
            return this;
        }

        public RemoteServiceLocatorBuilder remoteServer(String host, int port) {
            this.host = host;
            this.port = port;
            return this;
        }

        public RemoteServiceLocatorBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public RemoteServiceLocatorBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public JndiServiceLocator createServiceLocator() {
            try {
                Properties clientProp = new Properties();
                clientProp.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
                clientProp.put("remote.connections", "default");
                clientProp.put("remote.connection.default.port", Integer.toString(this.port));
                clientProp.put("remote.connection.default.host", this.host);
                clientProp.put("remote.connection.default.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS", "false");
                PropertiesBasedEJBClientConfiguration cc = new PropertiesBasedEJBClientConfiguration(clientProp);
                ConfigBasedEJBClientContextSelector selector = new ConfigBasedEJBClientContextSelector((EJBClientConfiguration)cc);
                EJBClientContext.setSelector((ContextSelector)selector);
                this.logger.debug("JBoss EJB Client Properties (used for remote lookup)" + clientProp);
                Properties props = new Properties();
                props.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                InitialContext ctx = new InitialContext(props);
                this.logger.debug("Creating RemoteServiceLocator [host={}:{}, app={} / module={}", new Object[]{this.host, this.port, this.appName, this.moduleName});
                return new RemoteServiceLocatorImpl(ctx, this.appName, this.moduleName);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't create ServiceLocator", (Throwable)ex);
            }
        }
    }
}

