/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.TxHandler;
import ch.inftec.ju.ee.test.TestRunnerAnnotationHandler;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.util.JuUtils;
import java.lang.reflect.Method;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;

@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestRunnerFacadeBean
implements TestRunnerFacade {
    private static Logger logger = Logger.getLogger(TestRunnerFacadeBean.class);
    @Inject
    private UserTransaction tx;
    @Inject
    private EntityManager em;

    @Override
    public void runPreTestActionsInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            handler.executePreTestAnnotations(new JuEmUtil(this.em));
            txHandler.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void runTestMethodInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            logger.debug((Object)String.format("Running Test %s", handler));
            handler.executeTestMethod();
            txHandler.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void runPostTestActionsInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        TxHandler txHandler;
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            txHandler = new TxHandler(this.tx, true);
            try {
                handler.executePostServerCode(new JuEmUtil(this.em));
                txHandler.commit();
            }
            finally {
                if (txHandler != null) {
                    txHandler.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            throwable = null;
            var3_5 = null;
            try {
                txHandler = new TxHandler(this.tx, true);
                try {
                    handler.executePostTestAnnotations(new JuEmUtil(this.em));
                    txHandler.commit();
                }
                finally {
                    if (txHandler != null) {
                        txHandler.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            if (((Boolean)JuUtils.getJuPropertyChain().get("ju-testing-ee.clearPropertyChainAfterEachTest", Boolean.class, "false")).booleanValue()) {
                JuUtils.clearPropertyChain();
            }
        }
    }

    @Override
    public Object runMethodInEjbContext(String className, String methodName, Class<?>[] argumentTypes, Object[] args) throws Exception {
        Throwable throwable = null;
        Object var6_7 = null;
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, argumentTypes);
            Object res = method.invoke(instance, args);
            txHandler.commit();
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

