/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.test;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.TxHandler;
import ch.inftec.ju.ee.test.TestRunnerAnnotationHandler;
import ch.inftec.ju.ee.test.TestRunnerFacade;
import ch.inftec.ju.util.JuObjectUtils;
import ch.inftec.ju.util.JuUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.junit.internal.AssumptionViolatedException;

@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestRunnerFacadeBean
implements TestRunnerFacade {
    private static Logger logger = Logger.getLogger(TestRunnerFacadeBean.class);
    @Inject
    private UserTransaction tx;
    @Inject
    private EntityManager em;

    @Override
    public void runPreTestActionsInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            handler.executePreTestAnnotations(new JuEmUtil(this.em));
            txHandler.commit();
        }
    }

    @Override
    public void runTestMethodInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            logger.debug((Object)String.format("Running Test %s", handler));
            try {
                handler.executeTestMethod();
            }
            catch (Throwable t) {
                InvocationTargetException ite;
                AssumptionViolatedException ave;
                if (t instanceof InvocationTargetException && (ave = (AssumptionViolatedException)JuObjectUtils.as((Object)(ite = (InvocationTargetException)t).getTargetException(), AssumptionViolatedException.class)) != null) {
                    throw new AssumptionViolatedException(ave.getMessage());
                }
                throw t;
            }
            txHandler.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runPostTestActionsInEjbContext(TestRunnerAnnotationHandler handler) throws Exception {
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            handler.executePostServerCode(new JuEmUtil(this.em));
            txHandler.commit();
        }
        try {
            txHandler = new TxHandler(this.tx, true);
            var3_3 = null;
            try {
                handler.executePostTestAnnotations(new JuEmUtil(this.em));
                txHandler.commit();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (txHandler != null) {
                    if (var3_3 != null) {
                        try {
                            txHandler.close();
                        }
                        catch (Throwable x2) {
                            var3_3.addSuppressed(x2);
                        }
                    } else {
                        txHandler.close();
                    }
                }
            }
        }
        finally {
            if (((Boolean)JuUtils.getJuPropertyChain().get("ju-testing-ee.clearPropertyChainAfterEachTest", Boolean.class, "false")).booleanValue()) {
                JuUtils.clearPropertyChain();
            }
        }
    }

    @Override
    public Object runMethodInEjbContext(String className, String methodName, Class<?>[] argumentTypes, Object[] args) throws Exception {
        try (TxHandler txHandler = new TxHandler(this.tx, true);){
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, argumentTypes);
            Object res = method.invoke(instance, args);
            txHandler.commit();
            Object object = res;
            return object;
        }
    }
}

