/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.JuDbException;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.IDataSet;

class ExportItems {
    private final List<ExportItem> items = new ArrayList<ExportItem>();
    private List<String> casedTableNames = new ArrayList<String>();

    ExportItems() {
    }

    public ExportItems add(String tableName, String query) {
        this.items.add(new TableQueryExportItem(tableName, query));
        return this;
    }

    public ExportItems setCasedTableNames(List<String> casedTableNames) {
        this.casedTableNames = casedTableNames;
        return this;
    }

    public IDataSet createDataSet(IDatabaseConnection conn) {
        if (this.items.size() > 0) {
            QueryDataSet dataSet = new QueryDataSet(conn, false);
            for (ExportItem item : this.items) {
                item.addToQueryDataSet(dataSet, this.casedTableNames);
            }
            return dataSet;
        }
        try {
            return conn.createDataSet();
        }
        catch (Exception ex) {
            throw new JuDbException("Couldn't export whole DB");
        }
    }

    private static class TableQueryExportItem
    implements ExportItem {
        private final String tableName;
        private final String query;

        private TableQueryExportItem(String tableName, String query) {
            this.tableName = tableName;
            this.query = query;
        }

        @Override
        public void addToQueryDataSet(QueryDataSet dataSet, List<String> casedTableNames) {
            try {
                String actualTableName = this.tableName;
                for (String casedTableName : casedTableNames) {
                    if (!casedTableName.equalsIgnoreCase(this.tableName)) continue;
                    actualTableName = casedTableName;
                    break;
                }
                dataSet.addTable(actualTableName, this.query);
            }
            catch (AmbiguousTableNameException ex) {
                throw new JuDbException(String.format("Couldn't add table %s to QueryDataSet: %s", this.tableName, this.query), (Throwable)ex);
            }
        }
    }

    static interface ExportItem {
        public void addToQueryDataSet(QueryDataSet var1, List<String> var2);
    }
}

