/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.EmfWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.JuEmfUtil;
import ch.inftec.ju.testing.db.DbTestAnnotationHandler;
import ch.inftec.ju.testing.db.EmfUtilProvider;
import ch.inftec.ju.testing.db.JuDbTest;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.TestUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDbTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected JuConnUtil connUtil;
    protected EntityManager em;
    protected JuEmUtil emUtil;
    private JuEmfUtil emfUtil;
    private EmfWork emfWork;
    @Rule
    public DbInitializerRule dbInitializer = new DbInitializerRule(this);

    public static void prepareSchemaByProfile() {
        new DbInitializerRule(null).prepareSchemaByProfile();
    }

    @After
    public void cleanupDb() {
        if (this.emfWork != null) {
            this.emfWork.close();
            this.emfWork = null;
            this.em = null;
        }
    }

    protected final void setRollbackOnly() {
        this.emfWork.setRollbackOnly();
    }

    protected final EmfWork startNewWork() {
        return this.emfUtil.startWork();
    }

    protected void runDbInitializationScripts(JuEmfUtil emfUtil) {
    }

    private static class DbInitializerRule
    implements TestRule {
        private Logger logger = LoggerFactory.getLogger(DbInitializerRule.class);
        private static final Set<String> createdSchemas = new HashSet<String>();
        private final AbstractDbTest dbTest;

        DbInitializerRule(AbstractDbTest dbTest) {
            this.dbTest = dbTest;
        }

        private void prepareSchemaByProfile() {
            String profile = JuUtils.getJuPropertyChain().get("ju-dbutil-test.profile", true);
            String adminPassword = JuUtils.getJuPropertyChain().get(String.format("ju-dbutil-test.%sAdmin.password", profile), false);
            String schemaName = JuUtils.getJuPropertyChain().get(String.format("ju-dbutil-test.%s.schema", profile), false);
            String userName = JuUtils.getJuPropertyChain().get(String.format("ju-dbutil-test.%s.user", profile), false);
            if (StringUtils.isEmpty((CharSequence)schemaName)) {
                schemaName = userName;
            }
            if (!createdSchemas.contains(schemaName) && !StringUtils.isEmpty((CharSequence)adminPassword)) {
                String adminProfile = profile + "Admin";
                this.logger.info("Admin-Profile defined: {}. Creating Schema '{}' if necessary", (Object)adminProfile, (Object)schemaName);
                JuConnUtil adminConnUtil = JuConnUtils.build().profile(adminProfile).create();
                boolean createSchema = true;
                if (adminConnUtil.getMetaDataInfo().getSchemaInfos().getSchemaNames().contains(schemaName)) {
                    boolean dropExistingSchema = (Boolean)JuUtils.getJuPropertyChain().get(String.format("ju-dbutil-test.%s.dropExistingSchema", adminProfile), Boolean.class, "false");
                    if (dropExistingSchema) {
                        this.logger.info("Schema {} already exists. Dropping and recreating.", (Object)schemaName);
                        List schemaInfos = adminConnUtil.getMetaDataInfo().getSchemaInfos().getSchemaInfos(schemaName, null);
                        Assert.assertEquals((String)"Catalogs not supported yet", (long)1L, (long)schemaInfos.size());
                        if (adminConnUtil.getDbType() == JuConnUtil.DbType.MYSQL) {
                            adminConnUtil.getDbHandler().dropSchema((JuConnUtil.MetaDataInfo.SchemaInfo)schemaInfos.get(0), new String[]{userName});
                        } else {
                            adminConnUtil.getDbHandler().dropSchema((JuConnUtil.MetaDataInfo.SchemaInfo)schemaInfos.get(0), new String[0]);
                        }
                    } else {
                        createSchema = false;
                        this.logger.info("Schema {} already exists. Skipping creation. Set dropExistingSchema for adminProfile to true if Schema should be dropped and recreated.", (Object)schemaName);
                    }
                }
                if (createSchema) {
                    this.logger.info("Creating Schema {}", (Object)schemaName);
                    String schemaPassword = JuUtils.getJuPropertyChain().get(String.format("ju-dbutil-test.%s.password", profile), false);
                    boolean jtaRecoveryGrants = (Boolean)JuUtils.getJuPropertyChain().get(String.format("ju-dbutil-test.%s.jtaRecoveryGrants", profile), Boolean.class, "false");
                    adminConnUtil.getDbHandler().createSchema().name(schemaName).user(userName).password(schemaPassword).jtaRecoveryGrants(jtaRecoveryGrants).create();
                    createdSchemas.add(schemaName);
                }
            }
        }

        public Statement apply(final Statement base, final Description description) {
            final Method method = TestUtils.getTestMethod((Description)description);
            String persistenceUnit = "ju-pu-test";
            String profile = null;
            JuDbTest juDbTest = method.getAnnotation(JuDbTest.class);
            if (juDbTest == null) {
                juDbTest = this.dbTest.getClass().getAnnotation(JuDbTest.class);
            }
            if (juDbTest != null) {
                persistenceUnit = juDbTest.persistenceUnit();
                profile = juDbTest.profile();
            }
            if (StringUtils.isEmpty(profile)) {
                profile = JuUtils.getJuPropertyChain().get("ju-dbutil-test.profile", true);
                this.prepareSchemaByProfile();
            }
            this.dbTest.connUtil = JuConnUtils.build().profile(profile).create();
            this.dbTest.emfUtil = new EmfUtilProvider().createEmfUtil(persistenceUnit, profile);
            return new Statement(){

                public void evaluate() throws Throwable {
                    DbInitializerRule.this.dbTest.runDbInitializationScripts(DbInitializerRule.this.dbTest.emfUtil);
                    DbTestAnnotationHandler annotationHandler = new DbTestAnnotationHandler(method, description);
                    try (EmfWork ew = DbInitializerRule.this.dbTest.emfUtil.startWork();){
                        annotationHandler.executePreTestAnnotations(ew.getEmUtil());
                    }
                    DbInitializerRule.this.dbTest.emfWork = DbInitializerRule.this.dbTest.emfUtil.startWork();
                    ((DbInitializerRule)DbInitializerRule.this).dbTest.em = DbInitializerRule.this.dbTest.emfWork.getEm();
                    ((DbInitializerRule)DbInitializerRule.this).dbTest.emUtil = new JuEmUtil(((DbInitializerRule)DbInitializerRule.this).dbTest.em);
                    base.evaluate();
                    ew = DbInitializerRule.this.dbTest.emfUtil.startWork();
                    var3_3 = null;
                    try {
                        annotationHandler.executePostServerCode(ew.getEmUtil());
                    }
                    catch (Throwable x2) {
                        var3_3 = x2;
                        throw x2;
                    }
                    finally {
                        if (ew != null) {
                            if (var3_3 != null) {
                                try {
                                    ew.close();
                                }
                                catch (Throwable x2) {
                                    var3_3.addSuppressed(x2);
                                }
                            } else {
                                ew.close();
                            }
                        }
                    }
                    ew = DbInitializerRule.this.dbTest.emfUtil.startWork();
                    var3_3 = null;
                    try {
                        annotationHandler.executePostTestAnnotations(ew.getEmUtil());
                    }
                    catch (Throwable throwable) {
                        var3_3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ew != null) {
                            if (var3_3 != null) {
                                try {
                                    ew.close();
                                }
                                catch (Throwable x2) {
                                    var3_3.addSuppressed(x2);
                                }
                            } else {
                                ew.close();
                            }
                        }
                    }
                }
            };
        }
    }
}

