/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.JuDbUtils;
import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.testing.db.data.TestDb;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.comparison.EqualityTester;
import ch.inftec.ju.util.comparison.ValueComparator;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@Deprecated
public abstract class AbstractBaseDbTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @PersistenceContext
    protected EntityManager em;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ConnectionInfo connectionInfo;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private TestDb testDb;
    @Autowired(required=false)
    private DefaultDataTypeFactory dataTypeFactor;
    @Autowired
    private JuDbUtils juDbUtils;

    protected final DbDataUtil createDbDataUtil() {
        DbDataUtil util = new DbDataUtil(this.em);
        if (this.dataTypeFactor != null) {
            util.setConfigProperty("http://www.dbunit.org/properties/datatypeFactory", this.dataTypeFactor);
        }
        return util;
    }

    @Before
    public final void resetDatabase() throws Exception {
        this.em.getMetamodel();
        if (this.testDb != null) {
            this.testDb.resetDatabase();
        }
    }

    protected void doInitDatabase() {
    }

    protected final void reInitConnection(boolean evictCache) {
        this.em.clear();
        if (evictCache) {
            this.em.getEntityManagerFactory().getCache().evictAll();
        }
    }

    protected void doReInitConnection() {
    }

    protected final void assertRowEquals(DbRow row, Map<String, Object> expectedValues) {
        HashMap<String, Object> rowValues = new HashMap<String, Object>();
        for (int i = 0; i < row.getColumnCount(); ++i) {
            rowValues.put(row.getColumnName(i), row.getValue(row.getColumnName(i)));
        }
        TestUtils.assertMapEquals(expectedValues, rowValues, (EqualityTester)ValueComparator.INSTANCE);
    }

    protected final void assertRowEquals(DbRow row, Object ... keyValuePairs) {
        this.assertRowEquals(row, JuCollectionUtils.stringMap((Object[])keyValuePairs));
    }

    public static class DbInitializerTestExecutionListener
    extends AbstractTestExecutionListener {
        public void beforeTestMethod(TestContext testContext) throws Exception {
            testContext.getTestClass().getMethod("resetDatabase", new Class[0]).invoke(testContext.getTestInstance(), new Object[0]);
        }
    }
}

