/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.testing.db.DefaultContextAbstractBaseDbTest;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.xml.XPathGetter;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DbDataUtilTest
extends DefaultContextAbstractBaseDbTest {
    @Before
    public void loadTestData() {
        this.createDbDataUtil().cleanImport("/datasets/fullData.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeToXmlFile() {
        File file = null;
        try {
            String fileName = "writeToXmlFile_team.xml";
            file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            this.createDbDataUtil().buildExport().addTable("Team", null).writeToXmlFile(fileName);
            Assert.assertTrue((boolean)file.exists());
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    @Test
    public void writeToDocument() {
        Document doc = this.createDbDataUtil().buildExport().addTable("Team", null).writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        Assert.assertEquals((long)2L, (long)xg.getSingleLong("count(//Team)").intValue());
    }

    @Test
    public void writeToDocument_query() {
        this.createDbDataUtil().buildImport().from("/datasets/testingEntityUnsortedData.xml").executeCleanInsert();
        Document doc = this.createDbDataUtil().buildExport().addTable("TestingEntity", "SELECT * FROM TESTINGENTITY WHERE ID=2").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        Assert.assertEquals((long)1L, (long)xg.getSingleLong("count(//TestingEntity)").intValue());
        Assert.assertEquals((long)2L, (long)xg.getSingleLong("//TestingEntity/@id").intValue());
    }

    @Test
    public void writeToDocument_order() {
        this.createDbDataUtil().buildImport().from("/datasets/testingEntityUnsortedData.xml").executeCleanInsert();
        Document doc = this.createDbDataUtil().buildExport().addTableSorted("TestingEntity", new String[]{"ID"}).writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        Assert.assertEquals((long)1L, (long)xg.getSingleLong("//TestingEntity[1]/@id").intValue());
        Assert.assertEquals((long)2L, (long)xg.getSingleLong("//TestingEntity[2]/@id").intValue());
        Assert.assertEquals((long)3L, (long)xg.getSingleLong("//TestingEntity[3]/@id").intValue());
    }

    @Test
    public void importDataFromXml() {
        Assert.assertEquals((long)1L, (long)this.em.createQuery("Select t from TestingEntity t").getResultList().size());
        this.createDbDataUtil().buildImport().from(JuUrl.resource().relativeTo(DbDataUtilTest.class).get("DbDataUtilsTest_importDataFromXml.xml")).executeCleanInsert();
        Assert.assertEquals((long)2L, (long)this.em.createQuery("Select t from TestingEntity t").getResultList().size());
    }

    @Test
    public void assertEqualsAll() {
        this.createDbDataUtil().buildAssert().expected(JuUrl.resource().relativeTo(DbDataUtilTest.class).get("DbDataUtilsTest_assertEqualsAll.xml")).assertEqualsAll();
    }

    @Test
    public void assertEqualsTables() {
        this.createDbDataUtil().buildAssert().expected(JuUrl.resource().relativeTo(DbDataUtilTest.class).get("DbDataUtilsTest_assertEqualsTables.xml")).assertEqualsTable("team", "name");
    }
}

