/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db.data;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.db.JuDbUtils;
import ch.inftec.ju.testing.db.data.TestDb;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public final class TestDbUtils {
    final Logger _log = LoggerFactory.getLogger(TestDbUtils.class);

    static abstract class AbstractTestDb
    implements TestDb {
        final Logger log = LoggerFactory.getLogger(AbstractTestDb.class);
        private static List<ConnectionInfo> initializedConnections = new ArrayList<ConnectionInfo>();
        @PersistenceContext
        protected EntityManager em;
        @Autowired
        protected JdbcTemplate jdbcTemplate;
        @Autowired
        private ConnectionInfo connectionInfo;
        @Autowired
        protected JuDbUtils juDbUtils;
        @Autowired
        private DataSource dataSource;

        AbstractTestDb() {
        }

        @PostConstruct
        private void init() {
            this.log.info("Creating tables for {}", (Object)this.connectionInfo);
            this.juDbUtils.setEntityManagerFactory(this.em.getEntityManagerFactory());
            this.juDbUtils.createDefaultTables();
            this.createTables();
        }

        protected void createTables() throws JuDbException {
        }

        protected void cleanup() throws JuDbException {
        }

        @Override
        public void initDb() throws JuDbException {
            if (!initializedConnections.contains(this.connectionInfo)) {
                this.log.debug("Initializing DB {}", (Object)this.connectionInfo);
                initializedConnections.add(this.connectionInfo);
                this.juDbUtils.createDefaultTables();
                this.createTables();
            }
        }

        @Override
        public void resetDatabase() throws JuDbException {
            this.resetPlatformSpecificData();
        }

        protected abstract void resetPlatformSpecificData() throws JuDbException;
    }
}

