/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.DataSet;
import ch.inftec.ju.testing.db.DataSetConfig;
import ch.inftec.ju.testing.db.DataSetExport;
import ch.inftec.ju.testing.db.DataVerifier;
import ch.inftec.ju.testing.db.DataVerify;
import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.testing.db.DbDataUtilConfig;
import ch.inftec.ju.testing.db.DbDataUtilProvider;
import ch.inftec.ju.testing.db.JuTestEnv;
import ch.inftec.ju.testing.db.PostServerCode;
import ch.inftec.ju.testing.db.ServerCode;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuObjectUtils;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.xml.XmlOutputConverter;
import ch.inftec.ju.util.xml.XmlUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DbTestAnnotationHandler
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DbTestAnnotationHandler.class);
    private final DbTestAnnotationInfo annoInfo;
    private final DataSetConfigInfo dataSetConfigInfo;
    protected final String testClassName;
    protected final String testMethodName;
    private final String testMethodReadableName;

    static DbTestAnnotationInfo getDbTestAnnotationInfo(Method testMethod) {
        return new DbTestAnnotationInfo(testMethod);
    }

    static DataSetConfigInfo getDataSetConfigInfo(DbTestAnnotationInfo annoInfo) {
        DataSetConfigInfo info = new DataSetConfigInfo();
        if (annoInfo.dataSetConfigAnnos.size() > 0) {
            DataSetConfig configAnno = (DataSetConfig)((ReflectUtils.AnnotationInfo)annoInfo.dataSetConfigAnnos.get(0)).getAnnotation();
            info.resourceDir = configAnno.resourceDir();
            info.resourcePrefix = configAnno.resourcePrefix();
            info.loadImportResourcesFromFileSystem = configAnno.loadImportResourcesFromFileSystem();
        } else {
            try {
                info.resourceDir = (String)DataSetConfig.class.getMethod("resourceDir", new Class[0]).getDefaultValue();
                info.resourcePrefix = (String)DataSetConfig.class.getMethod("resourcePrefix", new Class[0]).getDefaultValue();
                info.loadImportResourcesFromFileSystem = (Boolean)DataSetConfig.class.getMethod("loadImportResourcesFromFileSystem", new Class[0]).getDefaultValue();
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't get default values for DataSetConfig annotation", (Throwable)ex);
            }
        }
        return info;
    }

    public DbTestAnnotationHandler(Method method, Description description) {
        this.annoInfo = DbTestAnnotationHandler.getDbTestAnnotationInfo(method);
        this.dataSetConfigInfo = DbTestAnnotationHandler.getDataSetConfigInfo(this.annoInfo);
        this.testClassName = method.getDeclaringClass().getName();
        this.testMethodName = method.getName();
        this.testMethodReadableName = description.getMethodName();
    }

    private Class<?> getTestClass() {
        try {
            return Class.forName(this.testClassName);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't get test class. Make sure it's on the classpath: " + this.testClassName);
        }
    }

    public SystemPropertyTempSetter initContainerTestEnv() {
        return DbTestAnnotationHandler.setTestEnvProperties(this.annoInfo.testEnvAnnos);
    }

    public static SystemPropertyTempSetter setTestEnvProperties(List<ReflectUtils.AnnotationInfo<JuTestEnv>> testEnvAnnos) {
        SystemPropertyTempSetter tempSetter = new SystemPropertyTempSetter();
        try {
            for (ReflectUtils.AnnotationInfo<JuTestEnv> testEnvInfo : testEnvAnnos) {
                logger.debug("Processing Annotation (Setting system property): {}", testEnvInfo);
                for (String keyValStr : ((JuTestEnv)testEnvInfo.getAnnotation()).systemProperties()) {
                    if (StringUtils.isEmpty((CharSequence)keyValStr) || !keyValStr.contains("=")) {
                        throw new JuRuntimeException("SystemProperty String must be of type key=val, but was: %s", new Object[]{keyValStr});
                    }
                    int ind = keyValStr.indexOf("=");
                    String key = keyValStr.substring(0, ind);
                    String val = keyValStr.length() > ind - 1 ? keyValStr.substring(ind + 1) : "";
                    logger.debug("Setting system property for test context: {}={}", (Object)key, (Object)val);
                    tempSetter.setProperty(key, val);
                }
            }
        }
        catch (Exception ex) {
            tempSetter.close();
            throw ex;
        }
        return tempSetter;
    }

    private DbDataUtil getDbDataUtil(JuEmUtil emUtil) {
        if (this.annoInfo.dbDataUtilConfigAnnos.size() > 0) {
            ReflectUtils.AnnotationInfo annoInfo = (ReflectUtils.AnnotationInfo)this.annoInfo.dbDataUtilConfigAnnos.get(0);
            Class<? extends DbDataUtilProvider> providerClass = ((DbDataUtilConfig)annoInfo.getAnnotation()).value();
            logger.debug("Retrieving DbDataUtil from provider {} (defined in Annotation {}", providerClass, (Object)annoInfo);
            DbDataUtilProvider provider = (DbDataUtilProvider)ReflectUtils.newInstance(providerClass, (boolean)false, (Object[])new Object[0]);
            DbDataUtil dbDataUtil = provider.getDbDataUtil();
            if (dbDataUtil == null) {
                logger.warn("DbDataUtilProvider.getDbDataUtil() returned null. Creating DbDataUtil using JuEmUtil.");
            } else {
                return provider.getDbDataUtil();
            }
        }
        return new DbDataUtil(emUtil);
    }

    public final void executePreTestAnnotations(JuEmUtil emUtil) throws Exception {
        DbDataUtil du = this.getDbDataUtil(emUtil);
        Integer sequenceValue = null;
        for (ReflectUtils.AnnotationInfo dataSetInfo : this.annoInfo.dataSetAnnos) {
            logger.debug("Processing Annotation (Loading Data Sets): {}", (Object)dataSetInfo);
            this.runInitializer(((DataSet)dataSetInfo.getAnnotation()).preInitializer(), emUtil.getEm());
            if (!"".equals(((DataSet)dataSetInfo.getAnnotation()).value())) {
                URL resourceUrl = this.resourceToUrl(((DataSet)dataSetInfo.getAnnotation()).value(), this.dataSetConfigInfo.getResourceDirectory());
                du.buildImport().from(resourceUrl).executeCleanInsert();
            }
            for (String insertResource : ((DataSet)dataSetInfo.getAnnotation()).inserts()) {
                URL resourceUrl = this.resourceToUrl(insertResource, this.dataSetConfigInfo.getResourceDirectory());
                du.buildImport().from(resourceUrl).executeInsert();
            }
            sequenceValue = ((DataSet)dataSetInfo.getAnnotation()).sequenceValue();
            this.runInitializer(((DataSet)dataSetInfo.getAnnotation()).postInitializer(), emUtil.getEm());
        }
        if (sequenceValue != null) {
            emUtil.resetIdentityGenerationOrSequences(sequenceValue.intValue());
        }
    }

    private void runInitializer(Class<? extends ServerCode> clazz, EntityManager em) throws Exception {
        ServerCode initializer = (ServerCode)ReflectUtils.newInstance(clazz, (boolean)false, (Object[])new Object[0]);
        initializer.init(em);
        initializer.execute();
    }

    private URL resourceToUrl(String resource, String resourceDir) {
        String actualResource = resource;
        if (resource.indexOf("{param}") > 0) {
            String parameterizedTestName = this.getParameterizedTestName();
            AssertUtil.assertNotNull((String)("Doesn't seem to be parameterized test: " + this.testMethodReadableName), (Object)parameterizedTestName);
            actualResource = actualResource.replace("{param}", "[" + parameterizedTestName + "]");
        }
        URL url = null;
        if (!((Boolean)JuUtils.getJuPropertyChain().get("ju-testing.export.compareToResource", Boolean.class)).booleanValue() && this.dataSetConfigInfo.isLoadImportResourcesFromFileSystem() && !StringUtils.isEmpty((CharSequence)resourceDir)) {
            Path p = Paths.get(this.getLocalRoot(), resourceDir, actualResource);
            url = JuUrl.toUrl((Path)p);
        } else {
            url = JuUrl.resource().relativeTo(this.getTestClass()).get(actualResource);
            if (url == null) {
                url = JuUrl.resource((String)actualResource);
            }
        }
        if (url == null) {
            throw new JuRuntimeException(String.format("Couldn't find resource %s, relative to class %s", actualResource, this.getTestClass()));
        }
        return url;
    }

    protected String getLocalRoot() {
        return ".";
    }

    private String getParameterizedTestName() {
        if (this.testMethodReadableName.indexOf("[") < 0 || !this.testMethodReadableName.endsWith("]")) {
            return null;
        }
        return this.testMethodReadableName.substring(this.testMethodReadableName.indexOf("[") + 1, this.testMethodReadableName.length() - 1);
    }

    public final void executePostServerCode(JuEmUtil emUtil) throws Exception {
        for (ReflectUtils.AnnotationInfo codeInfo : this.annoInfo.postServerCodeAnnos) {
            logger.debug("Processing Annotation (Executing Post Server Code): {}", (Object)codeInfo);
            Class codeClass = null;
            if (((PostServerCode)codeInfo.getAnnotation()).value() == PostServerCode.DEFAULT_SERVER_CODE.class) {
                String verifierName = StringUtils.capitalize((String)(this.testMethodName + "_code"));
                Class defaultVerifier = ReflectUtils.getInnerClass(this.getTestClass(), (String)verifierName);
                AssertUtil.assertNotNull((String)String.format("Couldn't find Verifier %s as inner class of %s. Make sure it exists and is public static.", verifierName, this.getTestClass()), (Object)defaultVerifier);
                codeClass = defaultVerifier;
            } else {
                codeClass = ((PostServerCode)codeInfo.getAnnotation()).value();
            }
            this.runServerCode(codeClass, emUtil.getEm());
        }
    }

    String getExportFileName(DataSetExport dataSetExport) {
        String targetFileName = dataSetExport.exportName();
        if (StringUtils.isEmpty((CharSequence)targetFileName)) {
            targetFileName = String.format("%s_%s.xml", this.getTestClass().getSimpleName(), JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)this.testMethodReadableName));
        }
        return targetFileName;
    }

    public final void executePostTestAnnotations(JuEmUtil emUtil) throws Exception {
        Document doc = null;
        if (this.annoInfo.dataSetExportAnnos.size() > 0) {
            logger.debug("Processing Annotation (Exporting Data Set): {}", this.annoInfo.dataSetExportAnnos.get(0));
            DataSetExport dataSetExport = (DataSetExport)((ReflectUtils.AnnotationInfo)this.annoInfo.dataSetExportAnnos.get(0)).getAnnotation();
            if (dataSetExport.exportType() != DataSetExport.ExportType.NONE) {
                String targetFileName = this.getExportFileName(dataSetExport);
                URL tablesDataSestUrl = JuUrl.resource().relativeTo(this.getTestClass()).get(dataSetExport.tablesDataSet());
                if (tablesDataSestUrl == null) {
                    tablesDataSestUrl = JuUrl.resource((String)dataSetExport.tablesDataSet());
                }
                XmlOutputConverter xmlOutput = this.getDbDataUtil(emUtil).buildExport().addTablesByDataSet(tablesDataSestUrl, true).writeToXml();
                doc = xmlOutput.getDocument();
                if (dataSetExport.exportType() == DataSetExport.ExportType.PHYSICAL) {
                    if (((Boolean)JuUtils.getJuPropertyChain().get("ju-testing.export.compareToResource", Boolean.class, true)).booleanValue()) {
                        String resourcePrefix = this.dataSetConfigInfo.getResourcePrefix();
                        String resourcePath = resourcePrefix + "/" + targetFileName;
                        URL resourceUrl = JuUrl.singleResource((String)resourcePath);
                        String resourceString = new IOUtil().loadTextFromUrl(resourceUrl, new String[0]);
                        String xmlString = xmlOutput.getXmlString();
                        logger.debug("Comparing DB export to resource {}", (Object)resourceUrl);
                        Assert.assertEquals((Object)resourceString, (Object)xmlString);
                    } else {
                        String targetDirName = this.dataSetConfigInfo.getResourceDirectoryFull();
                        Path targetDirPath = Paths.get(this.getLocalRoot(), targetDirName);
                        Files.createDirectories(targetDirPath, new FileAttribute[0]);
                        Path targetFilePath = targetDirPath.resolve(targetFileName);
                        xmlOutput.writeToXmlFile(targetFilePath);
                    }
                } else if (dataSetExport.exportType() == DataSetExport.ExportType.MEMORY) {
                    if (logger.isInfoEnabled()) {
                        XString xs = new XString(targetFileName);
                        xs.newLine();
                        xs.addLine(XmlUtils.toString((Document)doc, (boolean)true, (boolean)true));
                        logger.info(xs.toString());
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported export type: " + (Object)((Object)dataSetExport.exportType()));
                }
            }
            if (this.annoInfo.dataSetExportAnnos.size() > 1) {
                logger.debug("Ignoring DataSetExport annotations as only first is processed:");
                for (int i = 1; i < this.annoInfo.dataSetExportAnnos.size(); ++i) {
                    logger.debug("Ignoring Annotation: {}", this.annoInfo.dataSetExportAnnos.get(i));
                }
            }
        }
        ArrayList<DataVerifier> verifiers = new ArrayList<DataVerifier>();
        for (ReflectUtils.AnnotationInfo verifyInfo : this.annoInfo.dataVerifyAnnos) {
            logger.debug("Processing Annotation (Data Verifying): {}", (Object)verifyInfo);
            Class verifierClass = null;
            if (((DataVerify)verifyInfo.getAnnotation()).value() == DataVerify.DEFAULT_DATA_VERIFIER.class) {
                String verifierName = StringUtils.capitalize((String)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)this.testMethodName));
                Class defaultVerifier = ReflectUtils.getInnerClass(this.getTestClass(), (String)verifierName);
                AssertUtil.assertNotNull((String)String.format("Couldn't find Verifier %s as inner class of %s. Make sure it exists and is public static.", verifierName, this.getTestClass()), (Object)defaultVerifier);
                verifierClass = defaultVerifier;
            } else {
                verifierClass = ((DataVerify)verifyInfo.getAnnotation()).value();
            }
            verifiers.add(this.createVerifier(verifierClass, emUtil.getEm(), doc));
        }
        for (DataVerifier verifier : verifiers) {
            verifier.verify();
        }
    }

    private void runServerCode(Class<?> codeClass, EntityManager em) throws Exception {
        AssertUtil.assertTrue((String)("Code class must be of type ServerCode: " + codeClass.getName()), (boolean)ServerCode.class.isAssignableFrom(codeClass));
        ServerCode code = (ServerCode)ReflectUtils.newInstance(codeClass, (boolean)false, (Object[])new Object[0]);
        code.init(em);
        try {
            code.execute();
        }
        catch (Exception ex) {
            this.handleServerThrowable(ex);
        }
    }

    protected final <T extends Throwable> void handleServerThrowable(T t) throws T {
        if (!IOUtil.isSerializable(t)) {
            Throwable cause;
            InvocationTargetException ite = (InvocationTargetException)JuObjectUtils.as(t, InvocationTargetException.class);
            if (ite != null && ite.getTargetException() instanceof AssumptionViolatedException) {
                throw new AssumptionViolatedException(ite.getTargetException().getMessage());
            }
            XString causes = new XString("%s (Original Exception %s not serializable. Resolving chain", new Object[]{t.getMessage(), t.getClass().getName()});
            Object tChain = t;
            if (ite != null) {
                causes.addLineFormatted("%s [Target: %s]", new Object[]{ite.getMessage(), ite.getTargetException()});
                if (ite.getTargetException() != null) {
                    tChain = ite.getTargetException();
                }
            }
            for (cause = tChain.getCause(); cause != null && !IOUtil.isSerializable((Object)cause); cause = cause.getCause()) {
                causes.addLineFormatted("%s [Caused by: %s (non-serializable)", new Object[]{cause.getMessage(), cause.getClass().getName()});
            }
            if (cause != null) {
                throw new JuRuntimeException(causes.toString(), cause);
            }
            causes.addLine("Check Server log for more details");
            throw new JuRuntimeException(causes.toString());
        }
        throw t;
    }

    private DataVerifier createVerifier(Class<?> verifierClass, EntityManager em, Document doc) {
        AssertUtil.assertTrue((String)("Verifier must be of type DataVerifier: " + verifierClass.getName()), (boolean)DataVerifier.class.isAssignableFrom(verifierClass));
        DataVerifier verifier = (DataVerifier)ReflectUtils.newInstance(verifierClass, (boolean)false, (Object[])new Object[0]);
        verifier.init(em, doc);
        this.initVerifier(verifier);
        return verifier;
    }

    protected void initVerifier(DataVerifier verifier) {
    }

    public String toString() {
        return String.format("%s.%s()", this.testClassName, this.testMethodReadableName);
    }

    static class DataSetConfigInfo
    implements Serializable {
        private String resourceDir;
        private String resourcePrefix;
        private boolean loadImportResourcesFromFileSystem;

        DataSetConfigInfo() {
        }

        public String getResourceDirectory() {
            return this.resourceDir;
        }

        public String getResourceDirectoryFull() {
            return Paths.get(this.resourceDir, this.resourcePrefix).toString();
        }

        public String getResourcePrefix() {
            return this.resourcePrefix;
        }

        public boolean isLoadImportResourcesFromFileSystem() {
            return this.loadImportResourcesFromFileSystem;
        }
    }

    static class DbTestAnnotationInfo
    implements Serializable {
        private final List<ReflectUtils.AnnotationInfo<DbDataUtilConfig>> dbDataUtilConfigAnnos;
        private final List<ReflectUtils.AnnotationInfo<JuTestEnv>> testEnvAnnos;
        private final List<ReflectUtils.AnnotationInfo<DataSet>> dataSetAnnos;
        private final List<ReflectUtils.AnnotationInfo<DataSetExport>> dataSetExportAnnos;
        private final List<ReflectUtils.AnnotationInfo<PostServerCode>> postServerCodeAnnos;
        private final List<ReflectUtils.AnnotationInfo<DataVerify>> dataVerifyAnnos;
        private final List<ReflectUtils.AnnotationInfo<DataSetConfig>> dataSetConfigAnnos;

        private DbTestAnnotationInfo(Method method) {
            this.dbDataUtilConfigAnnos = ReflectUtils.getAnnotationsWithInfo(method.getDeclaringClass(), DbDataUtilConfig.class, (boolean)true);
            this.testEnvAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, JuTestEnv.class, (boolean)false, (boolean)true, (boolean)true);
            Collections.reverse(this.testEnvAnnos);
            this.dataSetAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, DataSet.class, (boolean)false, (boolean)true, (boolean)true);
            Collections.reverse(this.dataSetAnnos);
            this.dataSetExportAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, DataSetExport.class, (boolean)true, (boolean)true, (boolean)true);
            this.postServerCodeAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, PostServerCode.class, (boolean)true, (boolean)false, (boolean)false);
            this.dataVerifyAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, DataVerify.class, (boolean)true, (boolean)false, (boolean)false);
            this.dataSetConfigAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, DataSetConfig.class, (boolean)true, (boolean)true, (boolean)true);
        }

        public List<ReflectUtils.AnnotationInfo<DataSet>> getDataSetAnnos() {
            return this.dataSetAnnos;
        }

        public List<ReflectUtils.AnnotationInfo<DataSetExport>> getDataSetExportAnnos() {
            return this.dataSetExportAnnos;
        }

        @DataSetConfig
        private static class DataSetConfigAnnotationUtil
        implements Serializable {
            private DataSetConfigAnnotationUtil() {
            }
        }
    }
}

