/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.DsWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import com.googlecode.flyway.core.Flyway;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchemaUtil {
    private final Logger logger = LoggerFactory.getLogger(DbSchemaUtil.class);
    private final JuConnUtil connUtil;

    public DbSchemaUtil(JuConnUtil connUtil) {
        this.connUtil = connUtil;
    }

    public DbSchemaUtil(JuEmUtil emUtil) {
        this(emUtil.asConnUtil());
    }

    public DbSchemaUtil(EntityManager em) {
        this(new JuEmUtil(em));
    }

    @Deprecated
    public DbSchemaUtil(EntityManager em, UserTransaction tx) {
        this(new JuEmUtil(em));
    }

    public void runLiquibaseChangeLog(String changeLogResourceName) {
        this.runLiquibaseChangeLog(changeLogResourceName, null);
    }

    private void runLiquibaseChangeLog(final String changeLogResourceName, final Map<String, String> parameters) {
        final JuConnUtil.DbType dbType = this.connUtil.getDbType();
        final String metaDataUserName = this.connUtil.getMetaDataInfo().getUserName();
        this.connUtil.doWork(new DbWork(){

            public void execute(Connection conn) {
                try {
                    JdbcConnection jdbcConn = new JdbcConnection(conn);
                    Database db = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConn);
                    if (dbType == JuConnUtil.DbType.ORACLE) {
                        db.setDefaultSchemaName(metaDataUserName);
                    }
                    Object resourceAccessor = new ClassLoaderResourceAccessor();
                    if (dbType == JuConnUtil.DbType.DERBY || dbType == JuConnUtil.DbType.H2 || dbType == JuConnUtil.DbType.HSQL) {
                        resourceAccessor = new ResourceAccessorFilter((ResourceAccessor)resourceAccessor);
                    }
                    Liquibase liquibase = new Liquibase(changeLogResourceName, (ResourceAccessor)resourceAccessor, db);
                    if (parameters != null) {
                        for (String key : parameters.keySet()) {
                            liquibase.setChangeLogParameter(key, parameters.get(key));
                        }
                    }
                    liquibase.update((String)null);
                }
                catch (Exception ex) {
                    throw new JuRuntimeException("Couldn't run Liquibase Update %s", (Throwable)ex, new Object[]{changeLogResourceName});
                }
            }
        });
    }

    public LiquibaseChangeLogBuilder liquibaseChangeLog() {
        return new LiquibaseChangeLogBuilder();
    }

    public void runFlywayMigration(final String ... locations) {
        this.connUtil.doWork(new DsWork(){

            public void execute(DataSource ds) {
                Flyway flyway = new Flyway();
                flyway.setDataSource(ds);
                flyway.setLocations(locations);
                flyway.migrate();
            }
        });
    }

    public void clearSchema() {
        this.connUtil.doWork(new DsWork(){

            public void execute(DataSource ds) {
                Flyway flyway = new Flyway();
                flyway.setDataSource(ds);
                flyway.clean();
            }
        });
    }

    public void prepareDefaultSchemaAndTestData() {
        this.prepareDefaultTestData(false, true, true);
    }

    public void loadDefaultTestData() {
        this.prepareDefaultTestData(false, true, false);
    }

    public void prepareDefaultTestData(boolean emptyTables, boolean resetSequences, boolean createSchema) {
        JuConnUtil.DbType dbType = this.connUtil.getDbType();
        if (createSchema) {
            this.runLiquibaseChangeLog("ju-testing/data/default-changeLog.xml");
            if (dbType != JuConnUtil.DbType.MYSQL) {
                this.runLiquibaseChangeLog("ju-testing/data/default-changeLog-hibernateSequence.xml");
            }
            if (dbType == JuConnUtil.DbType.MYSQL) {
                this.runLiquibaseChangeLog("ju-testing/data/default-changeLog-mySqlEngine.xml");
            }
        }
        DbDataUtil du = new DbDataUtil(this.connUtil);
        DbDataUtil.ImportBuilder fullData = du.buildImport().from("/ju-testing/data/default-fullData.xml");
        if (emptyTables) {
            fullData.executeDeleteAll();
        } else {
            fullData.executeCleanInsert();
        }
        if (this.connUtil.getDbType() != JuConnUtil.DbType.ORACLE && !emptyTables) {
            du.buildImport().from("/ju-testing/data/default-fullData-dataTypes.xml").executeUpdate();
        }
        if (resetSequences) {
            this.connUtil.getDbHandler().resetIdentityGenerationOrSequences(1);
        }
    }

    private class ResourceAccessorFilter
    implements ResourceAccessor {
        private final ResourceAccessor accessor;

        private ResourceAccessorFilter(ResourceAccessor accessor) {
            this.accessor = accessor;
        }

        public InputStream getResourceAsStream(String file) throws IOException {
            DbSchemaUtil.this.logger.debug("Removing replaceIfExists attribute for resource " + file);
            InputStream is = this.accessor.getResourceAsStream(file);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            String text = IOUtil.toString((Reader)reader);
            String newText = text.replaceAll("replaceIfExists=\"true\"", "");
            return new BufferedInputStream(new ByteArrayInputStream(newText.getBytes()));
        }

        public Enumeration<URL> getResources(String packageName) throws IOException {
            return this.accessor.getResources(packageName);
        }

        public ClassLoader toClassLoader() {
            return this.accessor.toClassLoader();
        }
    }

    public class LiquibaseChangeLogBuilder {
        private String resourcePath;
        private final Map<String, String> parameters = new HashMap<String, String>();

        public LiquibaseChangeLogBuilder changeLogResource(String resourcePath) {
            AssertUtil.assertNull((String)"Multiple resources not supported yet.", (Object)this.resourcePath);
            this.resourcePath = resourcePath;
            return this;
        }

        public LiquibaseChangeLogBuilder parameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        public void run() {
            DbSchemaUtil.this.runLiquibaseChangeLog(this.resourcePath, this.parameters);
        }
    }
}

