/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.util.AssertUtil;
import java.net.URL;
import java.sql.Connection;
import java.util.Enumeration;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;

public class LiquibaseDbUnitChange
implements CustomTaskChange {
    private String dataSet;
    private URL dataSetUrl;
    private boolean cleanInsert = true;
    private ResourceAccessor resourceAccessor;

    public String getConfirmationMessage() {
        return String.format("Imported data from dataSet %s as %s", this.dataSetUrl, this.cleanInsert ? "CleanInsert" : "Insert");
    }

    public void setUp() throws SetupException {
        AssertUtil.assertNotEmpty((String)"Parameter 'dataSet' must be set to the DbUnit dataSet to be executed", (String)this.dataSet);
        try {
            Enumeration urls = this.resourceAccessor.getResources(this.dataSet);
            AssertUtil.assertTrue((String)"ResourceAccessor couldn't locate resource", (boolean)urls.hasMoreElements());
            this.dataSetUrl = (URL)urls.nextElement();
            AssertUtil.assertFalse((String)"ResourceAccessor found more than one resource", (boolean)urls.hasMoreElements());
        }
        catch (Exception ex) {
            throw new SetupException("Couldn't find change set resource " + this.dataSet, (Throwable)ex);
        }
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void execute(Database database) throws CustomChangeException {
        AssertUtil.assertTrue((String)"Expected JdbcConnection to be able to extract raw JDBC connection", (boolean)(database.getConnection() instanceof JdbcConnection));
        JdbcConnection lbConn = (JdbcConnection)database.getConnection();
        Connection conn = lbConn.getWrappedConnection();
        DbDataUtil.executeInsert(conn, this.dataSetUrl, this.cleanInsert);
    }

    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public void setCleanInsert(boolean cleanInsert) {
        this.cleanInsert = cleanInsert;
    }
}

