/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.util.xml.XPathGetter;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DataVerifier {
    private Logger logger = LoggerFactory.getLogger(DataVerifier.class);
    protected EntityManager em;
    protected JuEmUtil emUtil;
    private XPathGetter xg;

    public final void init(EntityManager em, Document doc) {
        this.em = em;
        this.emUtil = new JuEmUtil(em);
        if (doc != null) {
            this.xg = new XPathGetter((Node)doc);
        }
    }

    public abstract void verify() throws Exception;

    protected final XPathGetter getXg() {
        if (this.xg == null) {
            this.logger.warn("XML verifying is only possible when using @DataSetExport with exportType != NONE");
            return null;
        }
        return this.xg.getGetter("/dataset");
    }
}

