/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.testing.db.DataSet;
import ch.inftec.ju.testing.db.DataSetExport;
import ch.inftec.ju.testing.db.DbTestAnnotationHandler;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.XString;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.junit.Test;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetExportSuite
extends ParentRunner<Runner> {
    private static Logger logger = LoggerFactory.getLogger(DataSetExportSuite.class);
    private DataSetAwareParentRunner<Runner> parentRunner;

    public DataSetExportSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        block5: {
            super(klass);
            logger.debug("Initializing DataSetExportSuite");
            logger.debug("Looking for RootSuite");
            List rootSuiteAnnos = ReflectUtils.getAnnotations(klass, RootSuite.class, (boolean)true);
            if (rootSuiteAnnos.size() > 0) {
                try {
                    Class<?> parentRunnerClass = ((RootSuite)rootSuiteAnnos.get(0)).value();
                    logger.debug("Found RootSuite: " + parentRunnerClass);
                    ParentRunner suiteRunner = (ParentRunner)new AnnotatedBuilder(builder).runnerForClass(parentRunnerClass);
                    this.parentRunner = new DataSetAwareParentRunner(suiteRunner);
                    XString xs = new XString();
                    ((DataSetAwareParentRunner)this.parentRunner).printDependencyReport(xs);
                    logger.info("DataSetExport Suite dependency information: \n\n" + xs.toString());
                    if (this.parentRunner.hasCyclicDependencies()) {
                        throw new JuRuntimeException("Cyclic dependencies detected. Check log for details.");
                    }
                    break block5;
                }
                catch (JuRuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new JuRuntimeException("Couldn't initialize RootSuite", (Throwable)ex);
                }
            }
            logger.debug("No RootSuite specified");
            throw new JuRuntimeException("DataSetExportSuite without RootSuite annotation not supported yet");
        }
    }

    protected List<Runner> getChildren() {
        return this.parentRunner.getChildren();
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public static class TestClass {
        @Test
        public void test() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RootSuite {
        public Class<?> value();
    }

    private static class DataSetObject {
        private final Set<String> dataSetImports = new LinkedHashSet<String>();
        private final Set<String> dataSetExports = new LinkedHashSet<String>();
        private final DataSetAwareParentRunner<?> relatedRunner;
        private final FrameworkMethod relatedMethod;
        private boolean hasCyclicDependency = false;

        public DataSetObject(DataSetAwareParentRunner<?> relatedRunner, FrameworkMethod relatedMethod) {
            this.relatedRunner = relatedRunner;
            this.relatedMethod = relatedMethod;
        }

        public Object getRelatedObject() {
            return this.relatedMethod != null ? this.relatedMethod : this.relatedRunner;
        }

        public void gatherDataSetInfos(Method m, Description desc) {
            logger.debug("Gathering DataSetInfos for method " + m);
            DbTestAnnotationHandler.DbTestAnnotationInfo annoInfo = DbTestAnnotationHandler.getDbTestAnnotationInfo(m);
            DbTestAnnotationHandler.DataSetConfigInfo configInfo = DbTestAnnotationHandler.getDataSetConfigInfo(annoInfo);
            for (ReflectUtils.AnnotationInfo<DataSet> annotationInfo : annoInfo.getDataSetAnnos()) {
                this.dataSetImports.add(this.getResourceString("", ((DataSet)annotationInfo.getAnnotation()).value()));
                for (String insert : ((DataSet)annotationInfo.getAnnotation()).inserts()) {
                    this.dataSetImports.add(this.getResourceString(configInfo.getResourcePrefix(), insert));
                }
            }
            for (ReflectUtils.AnnotationInfo annotationInfo : annoInfo.getDataSetExportAnnos()) {
                this.dataSetExports.add(this.getResourceString(configInfo.getResourcePrefix(), new DbTestAnnotationHandler(m, desc).getExportFileName((DataSetExport)annotationInfo.getAnnotation())));
            }
        }

        private String getResourceString(String resourcePrefix, String fileName) {
            return Paths.get(resourcePrefix, fileName).toString();
        }

        public void gatherDataSetInfos(List<DataSetObject> childObjects) {
            logger.debug("Gathering DataSetInfos for " + this);
            for (DataSetObject dsObject : childObjects) {
                this.dataSetImports.addAll(dsObject.dataSetImports);
                this.dataSetExports.addAll(dsObject.dataSetExports);
            }
        }

        public String toString() {
            if (this.relatedRunner != null) {
                return this.relatedRunner.getDescription().getDisplayName();
            }
            if (this.relatedMethod != null) {
                return this.relatedMethod.getName();
            }
            return super.toString();
        }
    }

    private static class DataSetAwareParentRunner<T>
    extends ParentRunner<T> {
        private final ParentRunner<T> originalRunner;
        private List<T> originalChildren;
        private List<DataSetObject> reorderedChildren;

        public DataSetAwareParentRunner(ParentRunner<T> originalRunner) throws InitializationError {
            super(originalRunner.getTestClass().getJavaClass());
            this.originalRunner = originalRunner;
            this.reorganizeRunner();
        }

        public boolean hasCyclicDependencies() {
            for (DataSetObject o : this.reorderedChildren) {
                if (o.hasCyclicDependency) {
                    return true;
                }
                if (o.relatedRunner == null) continue;
                return o.relatedRunner.hasCyclicDependencies();
            }
            return false;
        }

        private void reorganizeRunner() {
            try {
                List children;
                Method m = ReflectUtils.getDeclaredMethodInherited(this.originalRunner.getClass(), (String)"getChildren", null);
                m.setAccessible(true);
                this.originalChildren = children = (List)m.invoke(this.originalRunner, (Object[])null);
                this.reorderedChildren = new ArrayList<DataSetObject>();
                for (T originalChild : this.originalChildren) {
                    if (originalChild instanceof ParentRunner) {
                        DataSetAwareParentRunner<T> actualChild = new DataSetAwareParentRunner<T>((ParentRunner)originalChild);
                        DataSetObject dataSetObject = new DataSetObject(actualChild, null);
                        dataSetObject.gatherDataSetInfos(actualChild.reorderedChildren);
                        this.reorderedChildren.add(dataSetObject);
                        continue;
                    }
                    if (!(originalChild instanceof FrameworkMethod)) continue;
                    FrameworkMethod frameworkMethod = (FrameworkMethod)originalChild;
                    Method testMethod = frameworkMethod.getMethod();
                    System.err.println(testMethod);
                    DataSetObject dataSetObject = new DataSetObject(null, frameworkMethod);
                    dataSetObject.gatherDataSetInfos(testMethod, this.describeChild(originalChild));
                    this.reorderedChildren.add(dataSetObject);
                }
                logger.debug("Sorting runner " + this.originalRunner.getDescription().getDisplayName());
                this.sort(this.reorderedChildren);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't reorganize children for " + this.originalRunner.getDescription().getDisplayName(), (Throwable)ex);
            }
        }

        private void printDependencyReport(XString xs) {
            xs.addLine("Dependency info for " + this.originalRunner.getDescription().getDisplayName());
            xs.increaseIndent();
            for (DataSetObject o : this.reorderedChildren) {
                if (o.relatedRunner != null && o.relatedRunner instanceof DataSetAwareParentRunner) {
                    xs.newLine();
                    o.relatedRunner.printDependencyReport(xs);
                    continue;
                }
                xs.addLine(new Object[]{o});
                if (o.hasCyclicDependency) {
                    xs.addText(" -> ! CYCLIC DEPENDENCIES !");
                }
                xs.increaseIndent();
                if (!o.dataSetImports.isEmpty()) {
                    xs.addLine("Imports: ");
                    for (String imports : o.dataSetImports) {
                        xs.addText(imports);
                    }
                }
                if (!o.dataSetExports.isEmpty()) {
                    xs.addLine("Exports: ");
                    for (String exports : o.dataSetExports) {
                        xs.addText(exports);
                    }
                }
                xs.decreaseIndent();
            }
            xs.decreaseIndent();
        }

        protected List<T> getChildren() {
            ArrayList<Object> orderedChildrenList = new ArrayList<Object>();
            for (DataSetObject dataSetObject : this.reorderedChildren) {
                Object relatedObject = dataSetObject.getRelatedObject();
                orderedChildrenList.add(relatedObject);
            }
            return orderedChildrenList;
        }

        protected Description describeChild(T child) {
            try {
                Method m = ReflectUtils.getDeclaredMethodInherited(this.originalRunner.getClass(), (String)"describeChild", (Class[])new Class[]{Object.class});
                m.setAccessible(true);
                return (Description)m.invoke(this.originalRunner, child);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't invoke describeChild of base parent runner", (Throwable)ex);
            }
        }

        protected void runChild(T child, RunNotifier notifier) {
            try {
                Method m = ReflectUtils.getDeclaredMethodInherited(this.originalRunner.getClass(), (String)"runChild", (Class[])new Class[]{Object.class, RunNotifier.class});
                m.setAccessible(true);
                m.invoke(this.originalRunner, child, notifier);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't invoke runChild of base parent runner", (Throwable)ex);
            }
        }

        private void sort(List<DataSetObject> dataSetObjects) {
            ArrayList<DataSetObject> sortedObjects = new ArrayList<DataSetObject>();
            for (DataSetObject o : dataSetObjects) {
                if (!o.dataSetExports.isEmpty() || !o.dataSetImports.isEmpty()) continue;
                sortedObjects.add(o);
            }
            dataSetObjects.removeAll(sortedObjects);
            while (!dataSetObjects.isEmpty()) {
                for (DataSetObject o : dataSetObjects) {
                    boolean hasDependentImports = false;
                    block3: for (DataSetObject otherObject : dataSetObjects) {
                        if (otherObject == o) continue;
                        for (String imports : o.dataSetImports) {
                            if (!otherObject.dataSetExports.contains(imports)) continue;
                            hasDependentImports = true;
                            continue block3;
                        }
                    }
                    if (hasDependentImports) continue;
                    sortedObjects.add(o);
                }
                if (dataSetObjects.removeAll(sortedObjects)) continue;
            }
            if (!dataSetObjects.isEmpty()) {
                for (DataSetObject o : dataSetObjects) {
                    o.hasCyclicDependency = true;
                }
                sortedObjects.addAll(dataSetObjects);
                dataSetObjects.clear();
            }
            dataSetObjects.addAll(sortedObjects);
        }
    }
}

