/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.testing.db.DataSet;
import ch.inftec.ju.testing.db.DataSetExport;
import ch.inftec.ju.testing.db.DataSetExportSuite;
import ch.inftec.ju.util.TestUtils;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.extensions.cpsuite.ClasspathSuite;
import org.junit.rules.ExpectedException;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Suite;

public class DataSetExportSuiteTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void canRun_usingSuite() {
        DataSetExport_Suite._suite_TestClass.runCount = 0;
        Result res = TestUtils.runJUnitTests(DataSetExport_Suite.class);
        Assert.assertEquals((long)1L, (long)res.getRunCount());
        Assert.assertEquals((long)0L, (long)res.getFailureCount());
        Assert.assertEquals((long)1L, (long)DataSetExport_Suite._suite_TestClass.runCount);
    }

    @Test
    public void canRun_usingClasspathSuite() {
        DataSetExport_ClasspathSuite._cpSuite_TestClass.runCount = 0;
        Result res = TestUtils.runJUnitTests(DataSetExport_ClasspathSuite.class);
        Assert.assertEquals((long)1L, (long)res.getRunCount());
        Assert.assertEquals((long)0L, (long)res.getFailureCount());
        Assert.assertEquals((long)1L, (long)DataSetExport_ClasspathSuite._cpSuite_TestClass.runCount);
    }

    @Test
    public void canReorganize_dataSetExportOrder() {
        DataSetExport_ExportsSuite.MyTestExportsSuite.runCount = 0;
        Result res1 = TestUtils.runJUnitTests(DataSetExport_ExportsSuite.MyTestExportsSuite.class);
        this.checkTestOrder(res1, 0, 1, 2, 3);
        DataSetExport_ExportsSuite.MyTestExportsSuite.runCount = 0;
        Result res2 = TestUtils.runJUnitTests(DataSetExport_ExportsSuite.class);
        this.checkTestOrder(res2, 1, 0, 3, 2);
    }

    private void checkTestOrder(Result res, int ... orderIndexes) {
        Assert.assertEquals((long)4L, (long)res.getRunCount());
        Assert.assertEquals((long)0L, (long)res.getFailureCount());
        Assert.assertEquals((long)orderIndexes[0], (long)DataSetExport_ExportsSuite._exports_TestClass1.runIndex1);
        Assert.assertEquals((long)orderIndexes[1], (long)DataSetExport_ExportsSuite._exports_TestClass1.runIndex2);
        Assert.assertEquals((long)orderIndexes[2], (long)DataSetExport_ExportsSuite._exports_TestClass2.runIndex);
        Assert.assertEquals((long)orderIndexes[3], (long)DataSetExport_ExportsSuite._exports_TestClass2.runIndexNoImport);
    }

    @Test
    public void canDetect_cyclicDependency_inSameClass() {
        this.thrown.expectMessage("Cyclic dependencies detected");
        TestUtils.runJUnitTests(DataSetExport_ExportsSuite_Cyclic.class);
    }

    @Test
    public void canDetect_cyclicDependency_inDifferentClass() {
        this.thrown.expectMessage("Cyclic dependencies detected");
        TestUtils.runJUnitTests(DataSetExport_ExportsSuite_Cyclic2.class);
    }

    @Test
    public void canDetect_complexCyclicDependencies() {
        this.thrown.expectMessage("Cyclic dependencies detected");
        TestUtils.runJUnitTests(DataSetExport_ExportsSuite_Cyclic3.class);
    }

    @Test
    public void supports_nestedParentRunners() {
        DataSetExport_ExportsSuite_Nested.runCount = 0;
        Result res = TestUtils.runJUnitTests(DataSetExport_ExportsSuite_Nested.class);
        Assert.assertEquals((long)2L, (long)res.getRunCount());
        Assert.assertEquals((long)0L, (long)res.getFailureCount());
        Assert.assertEquals((long)0L, (long)DataSetExport_ExportsSuite_Nested._nested_testClass2.runIndex);
        Assert.assertEquals((long)1L, (long)DataSetExport_ExportsSuite_Nested._nested_testClass1.runIndex);
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestExportsSuite_Nested.class)
    public static class DataSetExport_ExportsSuite_Nested {
        private static int runCount;

        public static class _nested_testClass2 {
            private static int runIndex;

            @Test
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest1")
            public void test1() {
                runIndex = runCount++;
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_nested_testClass2.class})
        public static class _nested_testSuite {
        }

        public static class _nested_testClass1 {
            private static int runIndex;

            @Test
            @DataSet(value="dataSetExport/exportForTest1")
            public void test1() {
                runIndex = runCount++;
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_nested_testClass1.class, _nested_testSuite.class})
        public static class MyTestExportsSuite_Nested {
        }
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestExportsSuite_Cyclic3.class)
    public static class DataSetExport_ExportsSuite_Cyclic3 {

        @FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
        public static class _exports_TestClass1_Cyclic3 {
            @Test
            @DataSet(value="dataSetExport/exportForTest1")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest2")
            public void test1() {
            }

            @Test
            @DataSet(value="dataSetExport/exportForTest2")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest3")
            public void test2() {
            }

            @Test
            @DataSet(value="dataSetExport/exportForTest3")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest1")
            public void test3() {
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_exports_TestClass1_Cyclic3.class})
        public static class MyTestExportsSuite_Cyclic3 {
        }
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestExportsSuite_Cyclic2.class)
    public static class DataSetExport_ExportsSuite_Cyclic2 {

        public static class _exports_TestClass2_Cyclic2 {
            @Test
            @DataSet(value="dataSetExport/exportForTest2")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest1")
            public void test2() {
            }
        }

        public static class _exports_TestClass1_Cyclic2 {
            @Test
            @DataSet(value="dataSetExport/exportForTest1")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest2")
            public void test1() {
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_exports_TestClass1_Cyclic2.class, _exports_TestClass2_Cyclic2.class})
        public static class MyTestExportsSuite_Cyclic2 {
        }
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestExportsSuite_Cyclic.class)
    public static class DataSetExport_ExportsSuite_Cyclic {

        @FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
        public static class _exports_TestClass1_Cyclic {
            @Test
            @DataSet(value="dataSetExport/exportForTest1")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest2")
            public void test1() {
            }

            @Test
            @DataSet(value="dataSetExport/exportForTest2")
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest1")
            public void test2() {
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_exports_TestClass1_Cyclic.class})
        public static class MyTestExportsSuite_Cyclic {
        }
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestExportsSuite.class)
    public static class DataSetExport_ExportsSuite {

        @FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
        public static class _exports_TestClass2 {
            private static int runIndex = 0;
            private static int runIndexNoImport = 0;

            @Test
            @DataSet(value="someUnrelatedDataSet")
            @DataSetExport(tablesDataSet="ds")
            public void test() {
                runIndex = MyTestExportsSuite.runCount++;
            }

            @Test
            public void testNoImport() {
                runIndexNoImport = MyTestExportsSuite.runCount++;
            }
        }

        @FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
        public static class _exports_TestClass1 {
            private static int runIndex1 = 0;
            private static int runIndex2 = 0;

            @Test
            @DataSet(value="dataSetExport/exportForTest1")
            public void test1() {
                runIndex1 = MyTestExportsSuite.runCount++;
            }

            @Test
            @DataSetExport(tablesDataSet="ds", exportName="exportForTest1")
            public void test2() {
                runIndex2 = MyTestExportsSuite.runCount++;
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_exports_TestClass1.class, _exports_TestClass2.class})
        public static class MyTestExportsSuite {
            private static int runCount = 0;
        }
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestClasspathSuite.class)
    public static class DataSetExport_ClasspathSuite {

        public static class _cpSuite_TestClass {
            private static int runCount = 0;

            @Test
            public void test() {
                ++runCount;
            }
        }

        @RunWith(value=ClasspathSuite.class)
        @ClasspathSuite.ClassnameFilters(value={".*_cpSuite.*"})
        public static class MyTestClasspathSuite {
        }
    }

    @RunWith(value=DataSetExportSuite.class)
    @DataSetExportSuite.RootSuite(value=MyTestSuite.class)
    public static class DataSetExport_Suite {

        public static class _suite_TestClass {
            private static int runCount = 0;

            @Test
            public void test() {
                ++runCount;
            }
        }

        @RunWith(value=Suite.class)
        @Suite.SuiteClasses(value={_suite_TestClass.class})
        public static class MyTestSuite {
        }
    }
}

