/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db.data;

import ch.inftec.ju.db.JuDbUtils;
import ch.inftec.ju.testing.db.DefaultContextAbstractBaseDbTest;
import ch.inftec.ju.testing.db.data.entity.Player;
import ch.inftec.ju.testing.db.data.entity.Team;
import ch.inftec.ju.util.JuCollectionUtils;
import java.util.List;
import javax.persistence.Query;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class TestDbTest
extends DefaultContextAbstractBaseDbTest {
    @Autowired
    private JuDbUtils juDbUtils;

    @Before
    public void loadTestData() {
        this.createDbDataUtil().cleanImport("/datasets/fullData.xml");
    }

    @Test
    public final void testA() {
        List columnNames = this.juDbUtils.getColumnNames("TEST_A");
        Assert.assertEquals((int)3, (int)columnNames.size());
        Assert.assertTrue((boolean)columnNames.containsAll(JuCollectionUtils.arrayList((Object[])new String[]{"AID", "TEXT", "B_FK"})));
        int cnt = this.jdbcTemplate.queryForInt("select count(*) from test_a");
        Assert.assertEquals((int)3, (int)cnt);
    }

    @Test
    public final void testEntities() {
        Query q = this.em.createQuery("select p from Player p where p.firstName='All' and p.lastName='Star'");
        Player allstar = (Player)q.getSingleResult();
        Assert.assertEquals((String)"AllStar", (String)(allstar.getFirstName() + allstar.getLastName()));
        Assert.assertEquals((int)2, (int)allstar.getTeams().size());
        Assert.assertEquals((int)3, (int)((Team)allstar.getTeams().iterator().next()).getPlayers().size());
    }
}

