/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.DataSet;
import ch.inftec.ju.testing.db.DataSetExport;
import ch.inftec.ju.testing.db.DataVerifier;
import ch.inftec.ju.testing.db.DataVerify;
import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.testing.db.PostServerCode;
import ch.inftec.ju.testing.db.ServerCode;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.xml.XmlUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DbTestAnnotationHandler
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(DbTestAnnotationHandler.class);
    private final List<DataSet> dataSetAnnos;
    private final List<DataSetExport> dataSetExportAnnos;
    private final List<PostServerCode> postServerCodeAnnos;
    private final List<DataVerify> dataVerifyAnnos;
    protected final String testClassName;
    protected final String testMethodName;
    private final String testMethodReadableName;

    public DbTestAnnotationHandler(Method method, Description description) {
        this.dataSetAnnos = ReflectUtils.getAnnotations((Method)method, DataSet.class, (boolean)false, (boolean)true, (boolean)true);
        Collections.reverse(this.dataSetAnnos);
        this.dataSetExportAnnos = ReflectUtils.getAnnotations((Method)method, DataSetExport.class, (boolean)true, (boolean)true, (boolean)true);
        this.postServerCodeAnnos = ReflectUtils.getAnnotations((Method)method, PostServerCode.class, (boolean)true, (boolean)false, (boolean)false);
        this.dataVerifyAnnos = ReflectUtils.getAnnotations((Method)method, DataVerify.class, (boolean)true, (boolean)false, (boolean)false);
        this.testClassName = method.getDeclaringClass().getName();
        this.testMethodName = method.getName();
        this.testMethodReadableName = description.getMethodName();
    }

    private Class<?> getTestClass() {
        try {
            return Class.forName(this.testClassName);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't get test class. Make sure it's on the classpath: " + this.testClassName);
        }
    }

    public final void executePreTestAnnotations(JuEmUtil emUtil) throws Exception {
        DbDataUtil du = new DbDataUtil(emUtil);
        Integer sequenceValue = null;
        for (DataSet dataSet : this.dataSetAnnos) {
            this.runInitializer(dataSet.preInitializer(), emUtil.getEm());
            if (!"".equals(dataSet.value())) {
                URL resourceUrl = this.resourceToUrl(dataSet.value(), dataSet.resourceDir());
                du.buildImport().from(resourceUrl).executeCleanInsert();
            }
            for (String insertResource : dataSet.inserts()) {
                URL resourceUrl = this.resourceToUrl(insertResource, dataSet.resourceDir());
                du.buildImport().from(resourceUrl).executeInsert();
            }
            sequenceValue = dataSet.sequenceValue();
            this.runInitializer(dataSet.postInitializer(), emUtil.getEm());
        }
        if (sequenceValue != null) {
            emUtil.resetIdentityGenerationOrSequences(sequenceValue.intValue());
        }
    }

    private void runInitializer(Class<? extends ServerCode> clazz, EntityManager em) throws Exception {
        ServerCode initializer = (ServerCode)ReflectUtils.newInstance(clazz, (boolean)false, (Object[])new Object[0]);
        initializer.init(em);
        initializer.execute();
    }

    private URL resourceToUrl(String resource, String resourceDir) {
        String actualResource = resource;
        if (resource.indexOf("{param}") > 0) {
            String parameterizedTestName = this.getParameterizedTestName();
            AssertUtil.assertNotNull((String)("Doesn't seem to be parameterized test: " + this.testMethodReadableName), (Object)parameterizedTestName);
            actualResource = actualResource.replace("{param}", "[" + parameterizedTestName + "]");
        }
        URL url = null;
        if (!((Boolean)JuUtils.getJuPropertyChain().get("ju-testing.export.compareToResource", Boolean.class)).booleanValue() && !StringUtils.isEmpty((CharSequence)resourceDir)) {
            Path p = Paths.get(this.getLocalRoot(), resourceDir, actualResource);
            url = JuUrl.toUrl((Path)p);
        } else {
            url = JuUrl.resource().relativeTo(this.getTestClass()).get(actualResource);
            if (url == null) {
                url = JuUrl.resource((String)actualResource);
            }
        }
        if (url == null) {
            throw new JuRuntimeException(String.format("Couldn't find resource %s, relative to class %s", actualResource, this.getTestClass()));
        }
        return url;
    }

    protected String getLocalRoot() {
        return ".";
    }

    private String getParameterizedTestName() {
        if (this.testMethodReadableName.indexOf("[") < 0 || !this.testMethodReadableName.endsWith("]")) {
            return null;
        }
        return this.testMethodReadableName.substring(this.testMethodReadableName.indexOf("[") + 1, this.testMethodReadableName.length() - 1);
    }

    protected void initTestClass(Object instance) {
    }

    public final void executePostServerCode(JuEmUtil emUtil) throws Exception {
        for (PostServerCode code : this.postServerCodeAnnos) {
            Class codeClass = null;
            if (code.value() == PostServerCode.DEFAULT_SERVER_CODE.class) {
                String verifierName = StringUtils.capitalize((String)(this.testMethodName + "_code"));
                Class defaultVerifier = ReflectUtils.getInnerClass(this.getTestClass(), (String)verifierName);
                AssertUtil.assertNotNull((String)String.format("Couldn't find Verifier %s as inner class of %s. Make sure it exists and is public static.", verifierName, this.getTestClass()), (Object)defaultVerifier);
                codeClass = defaultVerifier;
            } else {
                codeClass = code.value();
            }
            this.runServerCode(codeClass, emUtil.getEm());
        }
    }

    public final void executePostTestAnnotations(JuEmUtil emUtil) throws Exception {
        Document doc = null;
        if (this.dataSetExportAnnos.size() > 0) {
            DataSetExport dataSetExport = this.dataSetExportAnnos.get(0);
            String targetFileName = String.format("%s_%s.xml", this.getTestClass().getSimpleName(), JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)this.testMethodReadableName));
            URL tablesDataSestUrl = JuUrl.resource().relativeTo(this.getTestClass()).get(dataSetExport.tablesDataSet());
            if (tablesDataSestUrl == null) {
                tablesDataSestUrl = JuUrl.resource((String)dataSetExport.tablesDataSet());
            }
            DbDataUtil.ExportBuilder eb = new DbDataUtil(emUtil).buildExport().addTablesByDataSet(tablesDataSestUrl, true);
            doc = eb.writeToXmlDocument();
            if (dataSetExport.doPhysicalExport()) {
                if (((Boolean)JuUtils.getJuPropertyChain().get("ju-testing.export.compareToResource", Boolean.class, true)).booleanValue()) {
                    String resourcePrefix = dataSetExport.resourcePrefix();
                    String resourcePath = resourcePrefix + "/" + targetFileName;
                    URL resourceUrl = JuUrl.singleResource((String)resourcePath);
                    String resourceString = new IOUtil().loadTextFromUrl(resourceUrl, new String[0]);
                    String xmlString = eb.writeToXmlString();
                    this.logger.debug("Comparing DB export to resource {}", (Object)resourceUrl);
                    Assert.assertEquals((Object)resourceString, (Object)xmlString);
                } else {
                    String targetDirName = dataSetExport.targetDir();
                    Path targetDirPath = Paths.get(this.getLocalRoot(), targetDirName);
                    Files.createDirectories(targetDirPath, new FileAttribute[0]);
                    Path targetFilePath = targetDirPath.resolve(targetFileName);
                    eb.writeToXmlFile(targetFilePath.toString());
                }
            } else if (this.logger.isInfoEnabled()) {
                XString xs = new XString(targetFileName);
                xs.newLine();
                xs.addLine(XmlUtils.toString((Document)doc, (boolean)true, (boolean)true));
                this.logger.info(xs.toString());
            }
            if (this.dataSetExportAnnos.size() > 1) {
                this.logger.warn("Ignoring DataSetExport annotations as only first is processed");
            }
        }
        ArrayList<DataVerifier> verifiers = new ArrayList<DataVerifier>();
        for (DataVerify verify : this.dataVerifyAnnos) {
            Class verifierClass = null;
            if (verify.value() == DataVerify.DEFAULT_DATA_VERIFIER.class) {
                String verifierName = StringUtils.capitalize((String)JuStringUtils.removeNonAlphabeticalLeadingCharacters((String)this.testMethodName));
                Class defaultVerifier = ReflectUtils.getInnerClass(this.getTestClass(), (String)verifierName);
                AssertUtil.assertNotNull((String)String.format("Couldn't find Verifier %s as inner class of %s. Make sure it exists and is public static.", verifierName, this.getTestClass()), (Object)defaultVerifier);
                verifierClass = defaultVerifier;
            } else {
                verifierClass = verify.value();
            }
            verifiers.add(this.createVerifier(verifierClass, emUtil.getEm(), doc));
        }
        for (DataVerifier verifier : verifiers) {
            verifier.verify();
        }
    }

    private void runServerCode(Class<?> codeClass, EntityManager em) throws Exception {
        AssertUtil.assertTrue((String)("Code class must be of type ServerCode: " + codeClass.getName()), (boolean)ServerCode.class.isAssignableFrom(codeClass));
        ServerCode code = (ServerCode)ReflectUtils.newInstance(codeClass, (boolean)false, (Object[])new Object[0]);
        code.init(em);
        code.execute();
    }

    private DataVerifier createVerifier(Class<?> verifierClass, EntityManager em, Document doc) {
        AssertUtil.assertTrue((String)("Verifier must be of type DataVerifier: " + verifierClass.getName()), (boolean)DataVerifier.class.isAssignableFrom(verifierClass));
        DataVerifier verifier = (DataVerifier)ReflectUtils.newInstance(verifierClass, (boolean)false, (Object[])new Object[0]);
        verifier.init(em, doc);
        this.initVerifier(verifier);
        return verifier;
    }

    protected void initVerifier(DataVerifier verifier) {
    }

    public String toString() {
        return String.format("%s.%s()", this.testClassName, this.testMethodReadableName);
    }
}

