/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.DsWork;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.TxHandler;
import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import com.googlecode.flyway.core.Flyway;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.util.Enumeration;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchemaUtil {
    private final Logger logger = LoggerFactory.getLogger(DbSchemaUtil.class);
    private final JuEmUtil emUtil;
    private final TxHandler tx;

    public DbSchemaUtil(JuEmUtil emUtil) {
        this(emUtil, null);
    }

    private DbSchemaUtil(JuEmUtil emUtil, UserTransaction tx) {
        this.emUtil = emUtil;
        this.tx = tx != null ? new TxHandler(tx) : new TxHandler(this.emUtil.getEm());
    }

    public DbSchemaUtil(EntityManager em) {
        this(new JuEmUtil(em));
    }

    public DbSchemaUtil(EntityManager em, UserTransaction tx) {
        this(new JuEmUtil(em), tx);
    }

    public void runLiquibaseChangeLog(final String changeLogResourceName) {
        final JuEmUtil.DbType dbType = this.emUtil.getDbType();
        final String metaDataUserName = this.emUtil.getMetaDataUserName();
        this.tx.commit();
        this.emUtil.doWork(new DsWork(){

            public void execute(DataSource ds) {
                try (Connection conn = ds.getConnection();){
                    JdbcConnection jdbcConn = new JdbcConnection(conn);
                    Database db = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConn);
                    if (dbType == JuEmUtil.DbType.ORACLE) {
                        db.setDefaultSchemaName(metaDataUserName);
                    }
                    Object resourceAccessor = new ClassLoaderResourceAccessor();
                    if (dbType == JuEmUtil.DbType.DERBY || dbType == JuEmUtil.DbType.H2) {
                        resourceAccessor = new ResourceAccessorFilter((ResourceAccessor)resourceAccessor);
                    }
                    Liquibase liquibase = new Liquibase(changeLogResourceName, (ResourceAccessor)resourceAccessor, db);
                    liquibase.update(null);
                }
                catch (Exception ex) {
                    throw new JuRuntimeException("Couldn't run Liquibase change log " + changeLogResourceName, (Throwable)ex);
                }
            }
        });
        this.tx.begin();
    }

    public void runFlywayMigration(final String ... locations) {
        this.emUtil.doWork(new DsWork(){

            public void execute(DataSource ds) {
                Flyway flyway = new Flyway();
                flyway.setDataSource(ds);
                flyway.setLocations(locations);
                flyway.migrate();
            }
        });
    }

    public void clearSchema() {
        this.emUtil.doWork(new DsWork(){

            public void execute(DataSource ds) {
                Flyway flyway = new Flyway();
                flyway.setDataSource(ds);
                flyway.clean();
            }
        });
    }

    public void prepareDefaultSchemaAndTestData() {
        this.prepareDefaultTestData(false, true, true);
    }

    public void loadDefaultTestData() {
        this.prepareDefaultTestData(false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDefaultTestData(boolean emptyTables, boolean resetSequences, boolean createSchema) {
        try {
            JuEmUtil.DbType dbType = this.emUtil.getDbType();
            if (createSchema) {
                this.runLiquibaseChangeLog("ju-testing/data/default-changeLog.xml");
                if (dbType != JuEmUtil.DbType.MYSQL) {
                    this.runLiquibaseChangeLog("ju-testing/data/default-changeLog-hibernateSequence.xml");
                }
            }
            DbDataUtil du = new DbDataUtil(this.emUtil);
            DbDataUtil.ImportBuilder fullData = du.buildImport().from("/ju-testing/data/default-fullData.xml");
            if (emptyTables) {
                fullData.executeDeleteAll();
            } else {
                fullData.executeCleanInsert();
            }
            if (this.emUtil.getDbType() != JuEmUtil.DbType.ORACLE && !emptyTables) {
                du.buildImport().from("/ju-testing/data/default-fullData-dataTypes.xml").executeUpdate();
            }
            if (resetSequences) {
                this.emUtil.resetIdentityGenerationOrSequences(1);
            }
            this.tx.commit();
        }
        finally {
            this.tx.rollbackIfNotCommitted();
            this.tx.begin();
        }
    }

    private class ResourceAccessorFilter
    implements ResourceAccessor {
        private final ResourceAccessor accessor;

        private ResourceAccessorFilter(ResourceAccessor accessor) {
            this.accessor = accessor;
        }

        public InputStream getResourceAsStream(String file) throws IOException {
            DbSchemaUtil.this.logger.debug("Removing replaceIfExists attribute for Derby for resource " + file);
            InputStream is = this.accessor.getResourceAsStream(file);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            String text = IOUtil.toString((Reader)reader);
            String newText = text.replaceAll("replaceIfExists=\"true\"", "");
            return new BufferedInputStream(new ByteArrayInputStream(newText.getBytes()));
        }

        public Enumeration<URL> getResources(String packageName) throws IOException {
            return this.accessor.getResources(packageName);
        }

        public ClassLoader toClassLoader() {
            return this.accessor.toClassLoader();
        }
    }
}

