/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.CaseAwareFlatXmlWriter;
import ch.inftec.ju.testing.db.ExportItems;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.DataHolder;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.xml.XPathGetter;
import ch.inftec.ju.util.xml.XmlOutputConverter;
import ch.inftec.ju.util.xml.XmlUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DefaultMetadataHandler;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlMetadataHandler;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DbDataUtil {
    private final Connection connection;
    private final JuEmUtil emUtil;
    private String schemaName = null;
    private Map<String, Object> configProperties = new HashMap<String, Object>();

    @Deprecated
    public DbDataUtil(Connection connection) {
        this(connection, (String)null);
    }

    @Deprecated
    public DbDataUtil(Connection connection, String schema) {
        this.emUtil = null;
        this.connection = connection;
        this.schemaName = schema;
    }

    @Deprecated
    public DbDataUtil(Connection connection, ConnectionInfo connectionInfo) {
        this(connection, connectionInfo.getSchema());
    }

    public static void executeInsert(Connection conn, URL dataSetUrl, boolean cleanInsert) {
        ImportBuilder ib = new DbDataUtil(conn).buildImport().from(dataSetUrl);
        if (cleanInsert) {
            ib.executeCleanInsert();
        } else {
            ib.executeInsert();
        }
    }

    public DbDataUtil(EntityManager em) {
        this(new JuEmUtil(em));
    }

    public DbDataUtil(JuEmUtil emUtil) {
        this.emUtil = emUtil;
        this.connection = null;
        DefaultDataTypeFactory dataTypeFactory = null;
        DefaultMetadataHandler metadataHandler = new DefaultMetadataHandler();
        switch (this.emUtil.getDbType()) {
            case DERBY: {
                dataTypeFactory = new DefaultDataTypeFactory();
                break;
            }
            case H2: {
                dataTypeFactory = new H2DataTypeFactory();
                break;
            }
            case MYSQL: {
                dataTypeFactory = new MySqlDataTypeFactory();
                metadataHandler = new MySqlMetadataHandler();
                break;
            }
            case ORACLE: {
                this.setSchema(this.emUtil.getMetaDataUserName());
                dataTypeFactory = new Oracle10DataTypeFactory();
                break;
            }
            default: {
                throw new JuDbException("Unsupported DB: " + this.emUtil.getDbType());
            }
        }
        this.setConfigProperty("http://www.dbunit.org/properties/datatypeFactory", dataTypeFactory);
        this.setConfigProperty("http://www.dbunit.org/properties/metadataHandler", metadataHandler);
    }

    public DbDataUtil setSchema(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public DbDataUtil setConfigProperty(String name, Object value) {
        this.configProperties.put(name, value);
        return this;
    }

    private void execute(final DbUnitWork work) {
        if (this.connection != null) {
            this.doExecute(this.connection, work);
        } else if (this.emUtil != null) {
            this.emUtil.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    DbDataUtil.this.doExecute(connection, work);
                }
            });
        } else {
            throw new IllegalStateException("DbDataUtil hasn't been initialized correctly");
        }
    }

    private void doExecute(Connection connection, DbUnitWork work) {
        Connection unwrappedConn = null;
        if (this.emUtil != null && this.emUtil.getDbType() == JuEmUtil.DbType.ORACLE && connection instanceof Proxy) {
            try {
                unwrappedConn = connection.unwrap(Connection.class);
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't unwrap Connection", (Throwable)ex);
            }
        }
        Connection realConn = unwrappedConn != null ? unwrappedConn : connection;
        try {
            DatabaseConnection conn = new DatabaseConnection(realConn, this.schemaName);
            for (String key : this.configProperties.keySet()) {
                conn.getConfig().setProperty(key, this.configProperties.get(key));
            }
            work.execute((IDatabaseConnection)conn);
        }
        catch (DatabaseUnitException ex) {
            throw new JuDbException("Couldn't execute DbUnitWork", (Throwable)ex);
        }
    }

    public void cleanImport(String resourcePath) {
        this.buildImport().from(resourcePath).executeCleanInsert();
    }

    public ExportBuilder buildExport() {
        return new ExportBuilder(this);
    }

    public ImportBuilder buildImport() {
        return new ImportBuilder(this);
    }

    public AssertBuilder buildAssert() {
        return new AssertBuilder(this);
    }

    public static class AssertBuilder {
        private final DbDataUtil dbDataUtil;
        private FlatXmlDataSet flatXmlDataSet;
        private URL dataSetUrl;

        private AssertBuilder(DbDataUtil dbDataUtil) {
            this.dbDataUtil = dbDataUtil;
        }

        public AssertBuilder expected(String resourcePath) {
            URL url = JuUrl.resource().relativeTo(ReflectUtils.getCallingClass()).get(resourcePath);
            return this.expected(url);
        }

        public AssertBuilder expected(URL xmlUrl) {
            try {
                this.dataSetUrl = xmlUrl;
                this.flatXmlDataSet = new FlatXmlDataSetBuilder().build(xmlUrl);
                return this;
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't import data from XML: xmlUrl", (Throwable)ex);
            }
        }

        public void assertEquals() {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        IDataSet dbDataSet = AssertBuilder.this.dbDataUtil.buildExport().addTablesByDataSet(AssertBuilder.this.dataSetUrl, true).createDataSet(conn);
                        Assertion.assertEquals((IDataSet)AssertBuilder.this.flatXmlDataSet, (IDataSet)dbDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldn't assert DB data", (Throwable)ex);
                    }
                }
            });
        }

        public void assertEqualsAll() {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        IDataSet dbDataSet = conn.createDataSet();
                        Assertion.assertEquals((IDataSet)AssertBuilder.this.flatXmlDataSet, (IDataSet)dbDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldn't assert DB data", (Throwable)ex);
                    }
                }
            });
        }

        public void assertEqualsTable(final String tableName, final String orderColumnName) {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        QueryDataSet tableDataSet = new QueryDataSet(conn);
                        tableDataSet.addTable(tableName, String.format("select * from %s order by %s", tableName, orderColumnName));
                        Assertion.assertEquals((IDataSet)AssertBuilder.this.flatXmlDataSet, (IDataSet)tableDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldn't assert DB data", (Throwable)ex);
                    }
                }
            });
        }
    }

    public static class ImportBuilder {
        private Logger logger = LoggerFactory.getLogger(ImportBuilder.class);
        private final DbDataUtil dbDataUtil;
        private FlatXmlDataSet flatXmlDataSet;
        private URL dataSetUrl;

        private ImportBuilder(DbDataUtil dbDataUtil) {
            this.dbDataUtil = dbDataUtil;
        }

        public ImportBuilder from(String resourcePath) {
            URL url = JuUrl.resource().relativeTo(ReflectUtils.getCallingClass()).get(resourcePath);
            return this.from(url);
        }

        public ImportBuilder from(URL xmlUrl) {
            try {
                this.flatXmlDataSet = new FlatXmlDataSetBuilder().setColumnSensing(true).setCaseSensitiveTableNames(false).build(xmlUrl);
                this.dataSetUrl = xmlUrl;
                return this;
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't import data from XML: " + xmlUrl, (Throwable)ex);
            }
        }

        public void executeCleanInsert() {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        ImportBuilder.this.logger.debug("Executing Clean-Insert from: " + ImportBuilder.this.dataSetUrl);
                        DatabaseOperation.CLEAN_INSERT.execute(conn, (IDataSet)ImportBuilder.this.flatXmlDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldn't clean and insert data into DB", (Throwable)ex);
                    }
                }
            });
        }

        public void executeDeleteAll() {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        ImportBuilder.this.logger.debug("Executing Delete-All from: " + ImportBuilder.this.dataSetUrl);
                        DatabaseOperation.DELETE_ALL.execute(conn, (IDataSet)ImportBuilder.this.flatXmlDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldnt truncate data in DB", (Throwable)ex);
                    }
                }
            });
        }

        public void executeInsert() {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        ImportBuilder.this.logger.debug("Executing Insert from: " + ImportBuilder.this.dataSetUrl);
                        DatabaseOperation.INSERT.execute(conn, (IDataSet)ImportBuilder.this.flatXmlDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldnt insert data into DB", (Throwable)ex);
                    }
                }
            });
        }

        public void executeUpdate() {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    try {
                        ImportBuilder.this.logger.debug("Executing Update from: " + ImportBuilder.this.dataSetUrl);
                        DatabaseOperation.UPDATE.execute(conn, (IDataSet)ImportBuilder.this.flatXmlDataSet);
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldnt update data in DB", (Throwable)ex);
                    }
                }
            });
        }
    }

    public static class ExportBuilder {
        private Logger logger = LoggerFactory.getLogger(ExportBuilder.class);
        private final DbDataUtil dbDataUtil;
        private final ExportItems exportItems = new ExportItems();

        private ExportBuilder(DbDataUtil dbDataUtil) {
            this.dbDataUtil = dbDataUtil;
        }

        public ExportBuilder setTableNamesCasingByDataSet(String resourcePath) {
            try {
                this.exportItems.setCasedTableNames(new XPathGetter((Node)XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(DbDataUtil.class).get(resourcePath))).getNodeNames("dataset/*"));
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't load table names data set " + resourcePath, (Throwable)ex);
            }
            return this;
        }

        public ExportBuilder addTable(String tableName) {
            return this.addTable(tableName, null);
        }

        public ExportBuilder addTableSorted(String tableName) {
            AssertUtil.assertNotNull((String)"Sorting by primary key only works with DbDataUtils that were initialized with an JuEmUtil instance", (Object)this.dbDataUtil.emUtil);
            List primaryKeyColumns = this.dbDataUtil.emUtil.getPrimaryKeyColumns(tableName);
            return this.addTableSorted(tableName, primaryKeyColumns.toArray(new String[0]));
        }

        public ExportBuilder addTable(String tableName, String query) {
            this.exportItems.add(tableName, query);
            return this;
        }

        public ExportBuilder addTableSorted(String tableName, String ... orderColumns) {
            if (orderColumns.length == 0) {
                return this.addTable(tableName);
            }
            XString xs = new XString();
            xs.addFormatted("SELECT * FROM %s ORDER BY ", new Object[]{tableName});
            for (String orderColumn : orderColumns) {
                xs.assertText(new String[]{"ORDER BY ", ", "});
                xs.addText(orderColumn);
            }
            return this.addTable(tableName, xs.toString());
        }

        public ExportBuilder addTablesByDataSet(URL resourceUrl, boolean sortedByPrimaryKey) {
            try {
                Set tableNames = JuCollectionUtils.asSameOrderSet((Collection)new XPathGetter((Node)XmlUtils.loadXml((URL)resourceUrl)).getNodeNames("dataset/*"));
                for (String tableName : tableNames) {
                    if (sortedByPrimaryKey) {
                        this.addTableSorted(tableName);
                        continue;
                    }
                    this.addTable(tableName);
                }
                return this;
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't add tables by dataset " + resourceUrl, (Throwable)ex);
            }
        }

        private void doWork(final DataSetWork dataSetWork) {
            this.dbDataUtil.execute(new DbUnitWork(){

                @Override
                public void execute(IDatabaseConnection conn) {
                    dataSetWork.execute(ExportBuilder.this.createDataSet(conn));
                }
            });
        }

        private IDataSet createDataSet(IDatabaseConnection conn) {
            IDataSet dataSet = this.exportItems.createDataSet(conn);
            return dataSet;
        }

        public Document writeToXmlDocument() {
            final DataHolder doc = new DataHolder();
            this.doWork(new DataSetWork(){

                @Override
                public void execute(IDataSet dataSet) {
                    try {
                        XmlOutputConverter xmlConv = new XmlOutputConverter();
                        ExportBuilder.writeToXml(dataSet, xmlConv.getOutputStream());
                        doc.setValue((Object)xmlConv.getDocument());
                    }
                    catch (Exception ex) {
                        throw new JuDbException("Couldn't write DB data to XML document", (Throwable)ex);
                    }
                }
            });
            return (Document)doc.getValue();
        }

        public String writeToXmlString() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (final BufferedOutputStream stream = new BufferedOutputStream(bos);){
                this.doWork(new DataSetWork(){

                    @Override
                    public void execute(IDataSet dataSet) {
                        try {
                            ExportBuilder.writeToXml(dataSet, stream);
                        }
                        catch (Exception ex) {
                            throw new JuDbException("Couldn't write DB data to byte stream", (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't write DB data to byte stream", (Throwable)ex);
            }
            try {
                return bos.toString("utf-8");
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't convert byte array to String", (Throwable)ex);
            }
        }

        public void writeToXmlFile(final String fileName) {
            this.logger.debug("Writing dataset to XML file: " + fileName);
            try (final BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileName));){
                this.doWork(new DataSetWork(){

                    @Override
                    public void execute(IDataSet dataSet) {
                        try {
                            ExportBuilder.writeToXml(dataSet, stream);
                        }
                        catch (Exception ex) {
                            throw new JuDbException("Couldn't write DB data to file " + fileName, (Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't write DB data to file " + fileName, (Throwable)ex);
            }
        }

        private static void writeToXml(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
            CaseAwareFlatXmlWriter datasetWriter = new CaseAwareFlatXmlWriter(out, "utf-8");
            datasetWriter.setIncludeEmptyTable(true);
            datasetWriter.write(dataSet);
        }

        private static interface DataSetWork {
            public void execute(IDataSet var1);
        }
    }

    private static interface DbUnitWork {
        public void execute(IDatabaseConnection var1);
    }
}

