/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.EmfWork;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.JuEmfUtil;
import ch.inftec.ju.testing.db.DbTestAnnotationHandler;
import ch.inftec.ju.testing.db.EmfUtilProvider;
import ch.inftec.ju.testing.db.JuDbTest;
import ch.inftec.ju.util.TestUtils;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.junit.After;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDbTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected EntityManager em;
    protected JuEmUtil emUtil;
    private JuEmfUtil emfUtil;
    private EmfWork emfWork;
    @Rule
    public DbInitializerRule dbInitializer = new DbInitializerRule(this);

    @After
    public void cleanupDb() {
        if (this.emfWork != null) {
            this.emfWork.close();
            this.emfWork = null;
            this.em = null;
        }
    }

    protected final void setRollbackOnly() {
        this.emfWork.setRollbackOnly();
    }

    protected final EmfWork startNewWork() {
        return this.emfUtil.startWork();
    }

    protected void runDbInitializationScripts(JuEmfUtil emfUtil) {
    }

    private static class DbInitializerRule
    implements TestRule {
        private final AbstractDbTest dbTest;

        DbInitializerRule(AbstractDbTest dbTest) {
            this.dbTest = dbTest;
        }

        public Statement apply(final Statement base, final Description description) {
            final Method method = TestUtils.getTestMethod((Description)description);
            String persistenceUnit = "ju-pu-test";
            String profile = null;
            JuDbTest juDbTest = method.getAnnotation(JuDbTest.class);
            if (juDbTest == null) {
                juDbTest = this.dbTest.getClass().getAnnotation(JuDbTest.class);
            }
            if (juDbTest != null) {
                persistenceUnit = juDbTest.persistenceUnit();
                profile = juDbTest.profile();
            }
            this.dbTest.emfUtil = new EmfUtilProvider().createEmfUtil(persistenceUnit, profile);
            return new Statement(){

                public void evaluate() throws Throwable {
                    DbInitializerRule.this.dbTest.runDbInitializationScripts(DbInitializerRule.this.dbTest.emfUtil);
                    DbTestAnnotationHandler annotationHandler = new DbTestAnnotationHandler(method, description);
                    try (EmfWork ew = DbInitializerRule.this.dbTest.emfUtil.startWork();){
                        annotationHandler.executePreTestAnnotations(ew.getEmUtil());
                    }
                    DbInitializerRule.this.dbTest.emfWork = DbInitializerRule.this.dbTest.emfUtil.startWork();
                    ((DbInitializerRule)DbInitializerRule.this).dbTest.em = DbInitializerRule.this.dbTest.emfWork.getEm();
                    ((DbInitializerRule)DbInitializerRule.this).dbTest.emUtil = new JuEmUtil(((DbInitializerRule)DbInitializerRule.this).dbTest.em);
                    base.evaluate();
                    ew = DbInitializerRule.this.dbTest.emfUtil.startWork();
                    var3_3 = null;
                    try {
                        annotationHandler.executePostServerCode(ew.getEmUtil());
                    }
                    catch (Throwable x2) {
                        var3_3 = x2;
                        throw x2;
                    }
                    finally {
                        if (ew != null) {
                            if (var3_3 != null) {
                                try {
                                    ew.close();
                                }
                                catch (Throwable x2) {
                                    var3_3.addSuppressed(x2);
                                }
                            } else {
                                ew.close();
                            }
                        }
                    }
                    ew = DbInitializerRule.this.dbTest.emfUtil.startWork();
                    var3_3 = null;
                    try {
                        annotationHandler.executePostTestAnnotations(ew.getEmUtil());
                    }
                    catch (Throwable throwable) {
                        var3_3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ew != null) {
                            if (var3_3 != null) {
                                try {
                                    ew.close();
                                }
                                catch (Throwable x2) {
                                    var3_3.addSuppressed(x2);
                                }
                            } else {
                                ew.close();
                            }
                        }
                    }
                }
            };
        }
    }
}

