/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.testing.db.AbstractDbTest;
import ch.inftec.ju.testing.db.DbSchemaUtil;
import ch.inftec.ju.testing.db.JuDbTest;
import ch.inftec.ju.testing.db.data.entity.TestingEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LiquibaseTest
extends AbstractDbTest {
    @JuDbTest(profile="derby-lb", persistenceUnit="ju-testing-pu-liquibase")
    @Test
    public void canGenerateSchema_usingLiquibase() {
        Assert.assertEquals((long)0L, (long)this.emUtil.getTableNames().size());
        new DbSchemaUtil(this.em).runLiquibaseChangeLog("ch/inftec/ju/testing/db/LiquibaseTest_testingEntityChangeLog.xml");
        MatcherAssert.assertThat((Object)this.emUtil.getTableNames(), (Matcher)Matchers.hasItem((Object)"TESTINGENTITY"));
    }

    @JuDbTest(profile="derby-lb", persistenceUnit="ju-testing-pu-liquibase-dbUnitChange")
    @Test
    public void canExecute_dbUnitDataSet_asLiquibaseChangeSet() {
        Assert.assertEquals((long)0L, (long)this.emUtil.getTableNames().size());
        new DbSchemaUtil(this.em).runLiquibaseChangeLog("ch/inftec/ju/testing/db/LiquibaseTest_dbUnitChangeLog.xml");
        TestingEntity te = (TestingEntity)this.em.find(TestingEntity.class, (Object)1L);
        Assert.assertEquals((Object)"LiquibaseDbUnitChangeSet", (Object)te.getName());
    }
}

