/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ee.webtest;

import ch.inftec.ju.ee.webtest.WebTest;
import ch.inftec.ju.testing.db.JuAssumeUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import ch.inftec.ju.util.TestUtils;
import com.google.common.base.Function;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebTestTest {
    @Test
    public void canOpenGoogle_andSearchForCheese_usingChrome() {
        JuAssumeUtils.chromeIsAvailable();
        JuAssumeUtils.internetIsAvailable();
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-testing-ee.selenium.driver", "Chrome");
            TestUtils.runJUnitTests(GoogleSeleniumTest.class);
        }
    }

    @Test
    public void canOpenGoogle_andSearchForCheese_usingHtmlUnit() {
        JuAssumeUtils.internetIsAvailable();
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-testing-ee.selenium.driver", "HtmlUnit");
            ts.setProperty("ju-testing-ee.selenium.htmlUnit.enableJavascript", "false");
            TestUtils.runJUnitTests(GoogleSeleniumTest.class);
        }
    }

    @Test
    public void canOpenGoogle_andSearchForCheese_usingHtmlUnitAndChrome() {
        JuAssumeUtils.chromeIsAvailable();
        JuAssumeUtils.internetIsAvailable();
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-testing-ee.selenium.driver", "HtmlUnit,Chrome");
            ts.setProperty("ju-testing-ee.selenium.htmlUnit.enableJavascript", "false");
            TestUtils.runJUnitTests(GoogleSeleniumTest.class);
        }
    }

    public static class GoogleSeleniumTest
    extends WebTest {
        @Test
        public void canGoogle_forCheese() {
            this.driver.get("http://www.google.com");
            WebElement element = this.driver.findElement(By.name((String)"q"));
            element.sendKeys(new CharSequence[]{"Cheese!"});
            element.submit();
            this.logger.info("Page title is: " + this.driver.getTitle());
            new WebDriverWait(this.driver, 10L).until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.getTitle().toLowerCase().startsWith("cheese");
                }
            });
            this.logger.info("Page title is: " + this.driver.getTitle());
        }
    }
}

