/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.maven.util;

import ch.inftec.ju.security.JuSecurityUtils;
import ch.inftec.ju.util.InterpolatingPropertyChain;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyChainBuilder;
import ch.inftec.ju.util.RegexUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="properties")
public class PropertiesMojo
extends AbstractMojo {
    @Parameter
    private ChainConfig chain;
    @Component
    private MavenProject project;
    private Map<FilterConfig, List<RegexUtil>> includedPatterns = new HashMap<FilterConfig, List<RegexUtil>>();
    private Map<FilterConfig, List<RegexUtil>> excludedPatterns = new HashMap<FilterConfig, List<RegexUtil>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.chain != null) {
            PropertyChainBuilder chainBuilder = new PropertyChainBuilder();
            if (this.chain.resourceFolders.size() == 0) {
                chainBuilder.addResourceFolder(this.project.getBasedir().toPath());
            } else {
                for (File resourceFolder : this.chain.resourceFolders) {
                    if (this.chain.silentlyIgnoreMissingResourceFolder && !resourceFolder.exists()) continue;
                    chainBuilder.addResourceFolder(resourceFolder.toPath());
                }
            }
            for (ChainElementConfig chainElement : this.chain.chainElements) {
                if (chainElement.lookupConfigFile != null && chainElement.lookupConfigFile.fileName != null) {
                    chainBuilder.addEvaluatorsByChainFiles().name(chainElement.lookupConfigFile.fileName).resolve();
                }
                if (chainElement.systemProperties == null) continue;
                chainBuilder.addSystemPropertyEvaluator();
            }
            HashSet<String> exportedProperty = new HashSet<String>();
            if (this.chain.properties.size() > 0) {
                Properties props = new Properties();
                for (Property property : this.chain.properties) {
                    String key = chainBuilder.peekChain().interpolate(property.key);
                    String value = property.value;
                    if (value == null) continue;
                    props.put(key, value);
                    if (!property.exportToSystemProperty) continue;
                    exportedProperty.add(key);
                }
                chainBuilder.addPropertiesPropertyEvaluator(props);
            }
            if (this.chain.decryptor != null) {
                if (!StringUtils.isEmpty((CharSequence)this.chain.decryptor.decryptionPasswordPropertyName)) {
                    String decryptionPassword = chainBuilder.peekChain().get(this.chain.decryptor.decryptionPasswordPropertyName);
                    chainBuilder.setDecryptor(JuSecurityUtils.buildEncryptor().password(decryptionPassword).strong(this.chain.decryptor.strongEncryption).createTextEncryptor());
                } else if (!StringUtils.isEmpty((CharSequence)this.chain.decryptor.keyFilePathPropertyName)) {
                    String keyFileName = chainBuilder.peekChain().get(this.chain.decryptor.keyFilePathPropertyName);
                    try {
                        chainBuilder.setDecryptorByResource(keyFileName, this.chain.decryptor.strongEncryption);
                    }
                    catch (Exception ex) {
                        if (this.chain.decryptor.ignoreMissingDecryption) {
                            this.getLog().warn((CharSequence)("Couldn't set decryptor. Continuing as ignoreMissingDecryption is true: " + ex));
                        }
                        throw ex;
                    }
                }
            }
            InterpolatingPropertyChain chain = chainBuilder.getPropertyChain();
            Set keys = chain.listKeys();
            for (String key : keys) {
                boolean exportToSystemProperties;
                if (!this.isIncluded(key, this.chain.filter, true)) continue;
                PropertyChain.PropertyInfo pi = chain.getInfo(key);
                this.project.getProperties().put(key, pi.getValue());
                boolean bl = exportToSystemProperties = this.isIncluded(key, this.chain.exportToSystemProperty, false) || exportedProperty.contains(key);
                if (exportToSystemProperties) {
                    System.setProperty(key, pi.getValue());
                }
                if (!this.chain.logAddedKeys) continue;
                String addedKeyLog = String.format("Added key: %s=%s", key, pi.getDisplayValue());
                if (exportToSystemProperties) {
                    addedKeyLog = addedKeyLog + " (-> sys-export)";
                }
                this.getLog().info((CharSequence)addedKeyLog);
            }
        }
    }

    private boolean isIncluded(String key, FilterConfig filter, boolean includeIfNoFilter) {
        if (filter != null) {
            List<RegexUtil> includedPatterns = this.includedPatterns.get(filter);
            List<RegexUtil> excludedPatterns = this.excludedPatterns.get(filter);
            if (includedPatterns == null) {
                includedPatterns = new ArrayList<RegexUtil>();
                this.includedPatterns.put(filter, includedPatterns);
                excludedPatterns = new ArrayList<RegexUtil>();
                this.excludedPatterns.put(filter, excludedPatterns);
                if (this.chain != null && filter != null) {
                    for (String includeFilter : filter.includes) {
                        includedPatterns.add(new RegexUtil(includeFilter));
                    }
                    for (String excludeFilter : filter.excludes) {
                        excludedPatterns.add(new RegexUtil(excludeFilter));
                    }
                }
            }
            for (RegexUtil ru : excludedPatterns) {
                if (!ru.matches(key)) continue;
                return false;
            }
            if (includedPatterns.size() == 0) {
                return true;
            }
            for (RegexUtil ru : includedPatterns) {
                if (!ru.matches(key)) continue;
                return true;
            }
            return false;
        }
        return includeIfNoFilter;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public static class DecryptorConfig {
        @Parameter(property="ju.prop.decryptor.decryptionPasswordPropertyName")
        private String decryptionPasswordPropertyName;
        @Parameter(property="ju.prop.decryptor.keyFilePathPropertyName")
        private String keyFilePathPropertyName;
        @Parameter(property="ju.prop.decryptor.strongEncryption")
        private boolean strongEncryption;
        @Parameter(property="ju.prop.decryptor.ignoreMissingDecryption")
        private boolean ignoreMissingDecryption;
    }

    public static class FilterConfig {
        @Parameter
        private List<String> includes = new ArrayList<String>();
        @Parameter
        private List<String> excludes = new ArrayList<String>();
    }

    public static class Property {
        @Parameter
        public String key;
        @Parameter
        public String value;
        @Parameter(defaultValue="false")
        public boolean exportToSystemProperty;
    }

    public static class SystemPropertiesConfig {
    }

    public static class LookupConfigFileConfig {
        @Parameter
        private String fileName;
    }

    public static class ChainElementConfig {
        @Parameter
        private LookupConfigFileConfig lookupConfigFile;
        @Parameter
        private SystemPropertiesConfig systemProperties;
    }

    public static class ChainConfig {
        @Parameter
        private List<File> resourceFolders = new ArrayList<File>();
        @Parameter(property="ju.prop.silentlyIgnoreMissingResourceFolder")
        private boolean silentlyIgnoreMissingResourceFolder;
        @Parameter
        private List<ChainElementConfig> chainElements = new ArrayList<ChainElementConfig>();
        @Parameter
        private List<Property> properties = new ArrayList<Property>();
        @Parameter
        private FilterConfig filter;
        @Parameter
        private FilterConfig exportToSystemProperty;
        @Parameter(property="ju.prop.logAddedKeys", defaultValue="false")
        private boolean logAddedKeys;
        @Parameter
        private DecryptorConfig decryptor;
    }
}

