/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.maven;

import ch.inftec.ju.devops.FilesystemCleanup;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="filesystem-cleanup")
public class FilesystemCleanupMojo
extends AbstractMojo {
    @Parameter(alias="directory", property="directory", required=true)
    private File directory;
    @Parameter(alias="dryRun", property="dryRun", defaultValue="true", required=false)
    private boolean dryRun = true;
    @Parameter(alias="olderThan", property="olderThan", required=false)
    private int olderThan = 10;
    @Parameter(alias="keepMaxFiles", property="keepMax", required=false)
    private int keepMaxFiles = 15;
    @Parameter(alias="keepMinFiles", property="keepMin", required=false)
    private int keepMinFiles = 5;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FilesystemCleanup cleanup = new FilesystemCleanup(this.dryRun);
        this.getLog().info((CharSequence)String.format("start cleaning from %s", this.directory.getPath()));
        int result = cleanup.cleanup(this.directory, this.olderThan, this.keepMaxFiles, this.keepMinFiles);
        this.getLog().info((CharSequence)String.format("cleaned %d directories from %s", result, this.directory.getPath()));
    }
}

