/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.maven.versionoverride;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

@Mojo(name="version-override", defaultPhase=LifecyclePhase.VERIFY)
public class VersionOverrideMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            String versionOverride = System.getProperty("version.override");
            if (versionOverride != null) {
                this.getLog().info((CharSequence)"version.override: rewrite the version from the original pom.xml in pom-version.override.xml");
                File newPomFile = new File(this.project.getBasedir(), "pom-version.override.xml");
                newPomFile.createNewFile();
                this.replaceVersion(this.project.getFile(), newPomFile, versionOverride);
                this.project.setFile(newPomFile);
            }
        }
        catch (IOException e) {
            this.getLog().warn((Throwable)e);
        }
        catch (JDOMException e) {
            this.getLog().warn((Throwable)e);
        }
    }

    private void replaceVersion(File originalPomFile, File newPomFile, String newVersion) throws IOException, JDOMException {
        FileWriter writer = new FileWriter(newPomFile);
        SAXBuilder parser = new SAXBuilder();
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        Document doc = parser.build(originalPomFile);
        Element versionElem = this.findVersionElement(doc);
        versionElem.setText(newVersion);
        xmlOutput.output(doc, (Writer)writer);
        writer.flush();
        writer.close();
    }

    private Element findVersionElement(Document doc) {
        for (Element element : doc.getRootElement().getChildren()) {
            if (!element.getName().equals("version")) continue;
            return element;
        }
        for (Element element : doc.getRootElement().getChildren()) {
            if (!element.getName().equals("parent")) continue;
            for (Element childElem : element.getChildren()) {
                if (!childElem.getName().equals("version")) continue;
                return childElem;
            }
        }
        return null;
    }
}

