/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.maven.util;

import ch.inftec.ju.maven.util.PropertiesMojo;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.MojoRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PropertiesMojoTest {
    @Rule
    public MojoRule rule = new MojoRule();

    @Test
    public void canConfigureMojo_fromPom() throws Exception {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju.mojoProp", "origValue");
            PropertiesMojo propertiesMojo = (PropertiesMojo)this.rule.configureMojo((Mojo)new PropertiesMojo(), "ju-maven-plugin", new File("src/test/resources/test-poms/propertiesMojoTest/pom.xml"));
            propertiesMojo.execute();
            Assert.assertEquals((Object)"mojoVal", (Object)propertiesMojo.getProject().getProperties().get("ju.mojoProp"));
        }
    }

    @Test
    public void canFilterProperties() throws Exception {
        PropertiesMojo propertiesMojo = (PropertiesMojo)this.rule.configureMojo((Mojo)new PropertiesMojo(), "ju-maven-plugin", new File("src/test/resources/test-poms/propertiesMojoTest-filter/pom.xml"));
        propertiesMojo.execute();
        Properties props = propertiesMojo.getProject().getProperties();
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"val1", (Object)props.get("incProp1"));
        Assert.assertEquals((Object)"val2", (Object)props.get("incProp2"));
    }

    @Test
    public void supports_relativeResourceNames() throws Exception {
        PropertiesMojo propertiesMojo = (PropertiesMojo)this.rule.configureMojo((Mojo)new PropertiesMojo(), "ju-maven-plugin", new File("src/test/resources/test-poms/propertiesMojoTest-relative/pom.xml"));
        propertiesMojo.execute();
        Properties props = propertiesMojo.getProject().getProperties();
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"relProp", (Object)props.get("relKey"));
    }

    @Test
    public void canSpecify_decryptor() throws Exception {
        PropertiesMojo propertiesMojo = (PropertiesMojo)this.rule.configureMojo((Mojo)new PropertiesMojo(), "ju-maven-plugin", new File("src/test/resources/test-poms/propertiesMojoTest-decryptor/pom.xml"));
        propertiesMojo.execute();
        Properties props = propertiesMojo.getProject().getProperties();
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"String", (Object)props.get("encProperty"));
    }

    @Test
    public void canExport_property_toSystemProperties() throws Exception {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("propYesSysYes", "p1");
            ts.setProperty("propYesSysNo", "p2");
            ts.setProperty("propNoSysYes", "p3");
            ts.setProperty("propNoSysNo", "p4");
            PropertiesMojo propertiesMojo = (PropertiesMojo)this.rule.configureMojo((Mojo)new PropertiesMojo(), "ju-maven-plugin", new File("src/test/resources/test-poms/propertiesMojoTest-exportSystemProperty/pom.xml"));
            propertiesMojo.execute();
            Assert.assertEquals((long)2L, (long)propertiesMojo.getProject().getProperties().size());
            Assert.assertEquals((Object)"propYesSysYesVal", (Object)propertiesMojo.getProject().getProperties().get("propYesSysYes"));
            Assert.assertEquals((Object)"propYesSysNo", (Object)propertiesMojo.getProject().getProperties().get("propYesSysNo"));
            Assert.assertEquals((Object)"propYesSysYesVal", (Object)System.getProperty("propYesSysYes"));
            Assert.assertEquals((Object)"p2", (Object)System.getProperty("propYesSysNo"));
            Assert.assertEquals((Object)"p3", (Object)System.getProperty("propNoSysYes"));
            Assert.assertEquals((Object)"p4", (Object)System.getProperty("propNoSysNo"));
        }
    }

    @Test
    public void canSet_andInterpolate_properties() throws Exception {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("propSys", "p1");
            ts.setProperty("propMav", "p2");
            ts.setProperty("myKey", "p3");
            PropertiesMojo propertiesMojo = (PropertiesMojo)this.rule.configureMojo((Mojo)new PropertiesMojo(), "ju-maven-plugin", new File("src/test/resources/test-poms/propertiesMojoTest-setAndInterpolateProperty/pom.xml"));
            propertiesMojo.execute();
            Assert.assertEquals((long)5L, (long)propertiesMojo.getProject().getProperties().size());
            Assert.assertEquals((Object)"myKey", (Object)propertiesMojo.getProject().getProperties().get("keyProp"));
            Assert.assertEquals((Object)"myVal", (Object)propertiesMojo.getProject().getProperties().get("valProp"));
            Assert.assertEquals((Object)"valSys", (Object)propertiesMojo.getProject().getProperties().get("propSys"));
            Assert.assertEquals((Object)"myVal", (Object)propertiesMojo.getProject().getProperties().get("propMav"));
            Assert.assertEquals((Object)"myVal", (Object)propertiesMojo.getProject().getProperties().get("myKey"));
            Assert.assertEquals((Object)"valSys", (Object)System.getProperty("propSys"));
            Assert.assertEquals((Object)"p2", (Object)System.getProperty("propMav"));
            Assert.assertEquals((Object)"p3", (Object)System.getProperty("myKey"));
        }
    }
}

