/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.maven.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="debug", defaultPhase=LifecyclePhase.INITIALIZE)
public class DebugMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter
    private PrintPropertiesConfig printProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean outputPerformed = false;
        if (this.printProperties != null) {
            if (this.isPrintMavenProperties()) {
                this.printProperties("Maven", this.project.getProperties());
                outputPerformed = true;
            }
            if (this.isPrintSystemProperties()) {
                this.printProperties("System", System.getProperties());
                outputPerformed = true;
            }
        }
        if (!outputPerformed) {
            this.getLog().warn((CharSequence)"No output was configured on the JU Debug Plugin");
        }
    }

    private void printProperties(String name, Properties props) {
        this.getLog().info((CharSequence)String.format("Total %s Properties: %d", name, props.size()));
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            keys.add(ObjectUtils.toString((Object)object));
        }
        if (this.isSortProperties()) {
            Collections.sort(keys);
        }
        for (String string : keys) {
            Object value = props.get(string);
            this.getLog().info((CharSequence)String.format("  %s=%s", string, value));
        }
    }

    public boolean isPrintMavenProperties() {
        return this.printProperties != null && this.printProperties.maven;
    }

    public boolean isPrintSystemProperties() {
        return this.printProperties != null && this.printProperties.system;
    }

    public boolean isSortProperties() {
        return this.printProperties != null && this.printProperties.sort;
    }

    public static final class PrintPropertiesConfig {
        @Parameter(defaultValue="${ju.debug.printProperties.maven}")
        private boolean maven;
        @Parameter(defaultValue="${ju.debug.printProperties.system}")
        private boolean system;
        @Parameter(defaultValue="${ju.debug.printProperties.sort}")
        private boolean sort;
    }
}

