/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.json;

import ch.inftec.ju.util.JuRuntimeException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static String formatJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object obj = new ObjectMapper().readValue(json, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("JSON String: " + json);
            }
            throw new JuRuntimeException("Couldn't format JSON (see debug log for JSON String)", (Throwable)ex);
        }
    }

    public static MarshallerBuilder marshaller() {
        return new MarshallerBuilder();
    }

    public static final class MarshallerBuilder {
        private boolean formattedOutput = false;

        public MarshallerBuilder formattedOutput(boolean formattedOutput) {
            this.formattedOutput = formattedOutput;
            return this;
        }

        public String marshalToString(Object obj) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY, true);
                ObjectWriter writer = this.formattedOutput ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
                return writer.writeValueAsString(obj);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Marshalling of object to JSON failed", (Throwable)ex);
            }
        }
    }
}

