/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.json;

import ch.inftec.ju.json.JsonUtils;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.TestUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void canMarshall_simpleObject_toJson() {
        String json = JsonUtils.marshaller().marshalToString((Object)new SimpleObject("val1"));
        TestUtils.assertEqualsResource((String)"JsonUtilsTest_canMarshall_simpleObject_toJson.json", (String)json, (String[])new String[0]);
    }

    @Test
    public void canMarshall_complexObject_toJson() {
        String json = JsonUtils.marshaller().marshalToString((Object)new ComplexObject("val1", "val2", "vala", "valb", "valc"));
        TestUtils.assertEqualsResource((String)"JsonUtilsTest_canMarshall_complexObject_toJson.json", (String)json, (String[])new String[0]);
    }

    @Test
    public void canFormat_complexObject() {
        String json = JsonUtils.marshaller().formattedOutput(true).marshalToString((Object)new ComplexObject("val1", "val2", "vala", "valb", "valc"));
        TestUtils.assertEqualsResource((String)"JsonUtilsTest_canFormat_complexObject.json", (String)json, (String[])new String[0]);
    }

    @Test
    public void canFormat_jsonString() {
        String json = JsonUtils.marshaller().marshalToString((Object)new ComplexObject("val1", "val2", "vala", "valb", "valc"));
        String formattedJson = JsonUtils.formatJson((String)json);
        TestUtils.assertEqualsResource((String)"JsonUtilsTest_canFormat_complexObject.json", (String)formattedJson, (String[])new String[0]);
    }

    @Test
    public void marshalsProperties_alphabetically() {
        String json = JsonUtils.marshaller().marshalToString((Object)new UnsortedObject());
        TestUtils.assertEqualsResource((String)"JsonUtilsTest_marshalsProperties_alphabetically.json", (String)json, (String[])new String[0]);
    }

    @Test
    public void canEscape_specialCharacters() {
        String json = JsonUtils.marshaller().marshalToString((Object)new SimpleObject("\":{\\}"));
        TestUtils.assertEqualsResource((String)"JsonUtilsTest_canEscape_specialCharacters.json", (String)json, (String[])new String[0]);
    }

    public static final class UnsortedObject {
        public String getC() {
            return "c";
        }

        public String getA() {
            return "a";
        }

        public String getB() {
            return "b";
        }
    }

    public static final class ComplexObject {
        private String stringVal;
        private SimpleObject simpleObject;
        private List<String> stringList = new ArrayList<String>();

        public ComplexObject(String stringVal, String simpleObjectVal, String ... vals) {
            this.stringVal = stringVal;
            this.simpleObject = new SimpleObject(simpleObjectVal);
            this.stringList.addAll(JuCollectionUtils.arrayList((Object[])vals));
        }

        public String getStringVal() {
            return this.stringVal;
        }

        public SimpleObject getSimpleObject() {
            return this.simpleObject;
        }

        public List<String> getStringList() {
            return this.stringList;
        }
    }

    static final class SimpleObject {
        private String val;

        public SimpleObject(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }
}

