/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.jasypt;

import ch.inftec.ju.jasypt.Environment;
import ch.inftec.ju.jasypt.JasyptPropertiesDecryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.junit.After;
import org.junit.Test;

public class JasyptPropertiesDecryptorTest {
    List<String> filesToDelete = new ArrayList<String>();

    @After
    public void cleanup() {
        for (String fileName : this.filesToDelete) {
            File file = new File(fileName);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    @Test
    public void testInitialization() {
        String passwordFileEnvValue = "jasypt-init-test.txt";
        try {
            FileWriter writer = new FileWriter("jasypt-init-test.txt");
            writer.write("jasypt-init-test");
            writer.flush();
            writer.close();
            this.filesToDelete.add("jasypt-init-test.txt");
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "jasypt-init-test.txt";
                }
            });
            Assert.assertNotNull((Object)decryptor);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInitializationWithEmptyFile() {
        String passwordFileEnvValue = "jasypt-emptyfile-test.txt";
        try {
            FileWriter writer = new FileWriter("jasypt-emptyfile-test.txt");
            writer.write("     \n     \n  ");
            writer.flush();
            writer.close();
            this.filesToDelete.add("jasypt-emptyfile-test.txt");
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "jasypt-emptyfile-test.txt";
                }
            });
            Assert.fail((String)"should fail in case the given file has no content");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInitializationWithoutFile() {
        try {
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "non-exisiting-file.txt";
                }
            });
            Assert.fail((String)"should fail in case the given file doesn't exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInitializationWithNullEnvironment() {
        try {
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return null;
                }
            });
            Assert.fail((String)"should fail in case the environment variable is null");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInitializationWithEmptyStringEnvironment() {
        try {
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "      ";
                }
            });
            Assert.fail((String)"should fail in case the environment variable is null");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDecryption() {
        String passwordFileEnvValue = "jasypt-password.txt";
        String password = "foobar";
        File inputFile = new File("input-1.properties");
        try {
            this.createPropertyFile(inputFile, "foobar");
            Assert.assertTrue((String)"no encrypted values!!!!", (boolean)this.fileContainsEncryptedValues(inputFile));
            FileWriter writer = new FileWriter("jasypt-password.txt");
            writer.write("foobar");
            writer.flush();
            writer.close();
            this.filesToDelete.add("jasypt-password.txt");
            this.filesToDelete.add("input-1.properties");
            this.filesToDelete.add("output-1.properties");
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "jasypt-password.txt";
                }
            });
            Assert.assertNotNull((Object)decryptor);
            decryptor.processPropertyFile(inputFile, new File("output-1.properties"));
            File decryptedFile = new File("output-1.properties");
            Assert.assertTrue((String)("decrypted file " + decryptedFile.getName() + " doesn't exist"), (boolean)decryptedFile.exists());
            Assert.assertTrue((boolean)this.keyMatchesValue(decryptedFile));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSingleInputDecryption() {
        String passwordFileEnvValue = "jasypt-password.txt";
        String password = "foobar";
        String clearText = "hello world!";
        try {
            String encryptedInput = this.createSingleInput("hello world!", "foobar");
            FileWriter writer = new FileWriter("jasypt-password.txt");
            writer.write("foobar");
            writer.flush();
            writer.close();
            this.filesToDelete.add("jasypt-password.txt");
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "jasypt-password.txt";
                }
            });
            Assert.assertNotNull((Object)decryptor);
            String output = decryptor.processInput("decrypt.sh", encryptedInput);
            Assert.assertEquals((String)"hello world!", (String)output);
            String output1 = decryptor.processInput("decrypt.sh", "ENC(" + encryptedInput + ")");
            Assert.assertEquals((String)"hello world!", (String)output1);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDecryptionWithWrongPassword() {
        String passwordFileEnvValue = "jasypt-password.txt";
        String password = "foobar";
        File inputFile = new File("input-1.properties");
        try {
            this.createPropertyFile(inputFile, "foobar");
            Assert.assertTrue((String)"no encrypted values!!!!", (boolean)this.fileContainsEncryptedValues(inputFile));
            FileWriter writer = new FileWriter("jasypt-password.txt");
            writer.write("wrongpassword");
            writer.flush();
            writer.close();
            this.filesToDelete.add("jasypt-password.txt");
            this.filesToDelete.add("input-1.properties");
            this.filesToDelete.add("output-1.properties");
            JasyptPropertiesDecryptor decryptor = new JasyptPropertiesDecryptor(new Environment(){

                public String getenv(String envName) {
                    return "jasypt-password.txt";
                }
            });
            Assert.assertNotNull((Object)decryptor);
            decryptor.processPropertyFile(inputFile, new File("output-1.properties"));
            Assert.fail((String)"decryption with wrong password should not work");
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (EncryptionOperationNotPossibleException encryptionOperationNotPossibleException) {
            // empty catch block
        }
    }

    private String createSingleInput(String clearText, String password) throws IOException {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(password);
        return textEncryptor.encrypt(clearText);
    }

    private void createPropertyFile(File propertyFile, String password) throws IOException {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(password);
        Properties properties = new Properties();
        properties.setProperty("key.1.clear", "key.1.clear");
        properties.setProperty("key.2.clear", "key.2.clear");
        properties.setProperty("key.3.enc", String.format("ENC(%s)", textEncryptor.encrypt("key.3.enc")));
        properties.setProperty("key.4.clear", "key.4.clear");
        properties.setProperty("key.5.enc", String.format("ENC(%s)", textEncryptor.encrypt("key.5.enc")));
        properties.store(new FileOutputStream(propertyFile), "");
    }

    private boolean fileContainsEncryptedValues(File file) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(file));
        for (Object value : props.values()) {
            if (!value.toString().startsWith("ENC")) continue;
            return true;
        }
        return false;
    }

    private boolean keyMatchesValue(File decryptedPropertyFile) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(decryptedPropertyFile));
        for (Object key : props.keySet()) {
            if (key.toString().equals(props.getProperty(key.toString()))) continue;
            return false;
        }
        return true;
    }
}

