/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.client;

import ch.inftec.ju.ee.test.sim.RequestHolder;
import org.junit.Assert;
import org.junit.Test;

public class RequestHolderTest {
    @Test
    public void canPut_andPoll_requests() {
        RequestHolder rh = new RequestHolder();
        String req1a = "req1a";
        String req1b = "req1b";
        Integer req2 = 1;
        rh.putRequest(String.class, (Object)req1a);
        rh.putRequest(Integer.class, (Object)req2);
        rh.putRequest(String.class, (Object)req1b);
        Assert.assertEquals((Object)req1a, (Object)rh.pollRequest(String.class));
        Assert.assertEquals((Object)req1b, (Object)rh.pollRequest(String.class));
        Assert.assertEquals((Object)req2, (Object)rh.pollRequest(Integer.class));
    }

    @Test
    public void canPoll_lastRequest() {
        RequestHolder rh = new RequestHolder();
        String req1a = "req1a";
        String req1b = "req1b";
        rh.putRequest(String.class, (Object)req1a);
        rh.putRequest(String.class, (Object)req1b);
        Assert.assertEquals((Object)req1b, (Object)rh.pollLastRequest(String.class));
        Assert.assertNull((Object)rh.pollRequest(String.class));
    }

    @Test
    public void canPeek_Request() {
        RequestHolder rh = new RequestHolder();
        String req1a = "req1a";
        String req1b = "req1b";
        rh.putRequest(String.class, (Object)req1a);
        rh.putRequest(String.class, (Object)req1b);
        Assert.assertEquals((Object)req1a, (Object)rh.peekRequest(String.class));
        Assert.assertEquals((long)2L, (long)rh.getRequestCount(String.class));
    }

    @Test
    public void canPeek_LastRequest() {
        RequestHolder rh = new RequestHolder();
        String req1a = "req1a";
        String req1b = "req1b";
        rh.putRequest(String.class, (Object)req1a);
        rh.putRequest(String.class, (Object)req1b);
        Assert.assertEquals((Object)req1b, (Object)rh.peekLastRequest(String.class));
        Assert.assertEquals((long)2L, (long)rh.getRequestCount(String.class));
    }

    @Test
    public void canPeek_fromEndWithOffset() {
        RequestHolder rh = new RequestHolder();
        String req1a = "req1a";
        String req1b = "req1b";
        rh.putRequest(String.class, (Object)req1a);
        rh.putRequest(String.class, (Object)req1b);
        Assert.assertEquals((Object)req1b, (Object)rh.peekFromEndWithOffset(String.class, 0));
        Assert.assertEquals((Object)req1a, (Object)rh.peekFromEndWithOffset(String.class, 1));
        Assert.assertEquals((long)2L, (long)rh.getRequestCount(String.class));
    }

    @Test
    public void peekFromEndWithOffset_returnsNull_forOutOfBoundsOffset() {
        RequestHolder rh = new RequestHolder();
        String req1a = "req1a";
        rh.putRequest(String.class, (Object)req1a);
        Assert.assertNull((Object)rh.peekFromEndWithOffset(String.class, 1));
        Assert.assertEquals((long)1L, (long)rh.getRequestCount(String.class));
    }
}

