/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.client;

import ch.inftec.ju.ee.client.CalculatorBean;
import ch.inftec.ju.ee.client.JndiServiceLocator;
import ch.inftec.ju.ee.client.RemoteCalculator;
import ch.inftec.ju.ee.client.ServiceLocatorBuilder;
import ch.inftec.ju.ee.test.AbstractTestBean;
import ch.inftec.ju.ee.test.TestRemote;
import ch.inftec.ju.ee.test.TestRemoteBean;
import ch.inftec.ju.util.JuUrl;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class RemoteServiceLocatorTest {
    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        war.addClass(AbstractTestBean.class);
        war.addClass(TestRemote.class);
        war.addClass(TestRemoteBean.class);
        war.addClass(RemoteCalculator.class);
        war.addClass(CalculatorBean.class);
        war.addAsManifestResource(JuUrl.existingResourceRelativeToAndPrefixed((String)"ejb-jar.xml", RemoteServiceLocatorTest.class), "ejb-jar.xml");
        return war;
    }

    @Test
    public void canLookup_testFacadeBean_usingEjbClientApi() throws Exception {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        InitialContext context = new InitialContext(jndiProperties);
        TestRemote testRemote = (TestRemote)context.lookup("ejb:/test//TestRemoteInterfaceBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to EjbClientApi", (Object)testRemote.getGreeting("EjbClientApi"));
    }

    @Test
    public void canLookup_remoteCalculator_usingEjbClientApi() throws Exception {
        RemoteCalculator calculator = RemoteServiceLocatorTest.lookupRemoteStatelessCalculator();
        Assert.assertEquals((long)3L, (long)calculator.add(1, 2));
    }

    private static RemoteCalculator lookupRemoteStatelessCalculator() throws NamingException {
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        InitialContext context = new InitialContext(jndiProperties);
        String appName = "";
        String moduleName = "test";
        String distinctName = "";
        String beanName = CalculatorBean.class.getSimpleName();
        String viewClassName = RemoteCalculator.class.getName();
        return (RemoteCalculator)context.lookup("ejb:/test//" + beanName + "!" + viewClassName);
    }

    @Test
    public void canLookup_testFacadeBean_usingEjbClientApi_withoutFile() throws Exception {
        Properties clientProp = new Properties();
        clientProp.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
        clientProp.put("remote.connections", "default");
        clientProp.put("remote.connection.default.port", "8080");
        clientProp.put("remote.connection.default.host", "localhost");
        clientProp.put("remote.connection.default.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS", "false");
        PropertiesBasedEJBClientConfiguration cc = new PropertiesBasedEJBClientConfiguration(clientProp);
        ConfigBasedEJBClientContextSelector selector = new ConfigBasedEJBClientContextSelector((EJBClientConfiguration)cc);
        EJBClientContext.setSelector((ContextSelector)selector);
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        InitialContext context = new InitialContext(jndiProperties);
        TestRemote testRemote = (TestRemote)context.lookup("ejb:/test//TestRemoteInterfaceBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to EjbClientApi", (Object)testRemote.getGreeting("EjbClientApi"));
    }

    @Ignore(value="PR-285 Not working with WildFly 10, didn't investigate further. We probably don't need this...")
    @Test
    public void canLookup_testFacadeBean_usingRemoteNaming() throws Exception {
        Properties jndiProps = new Properties();
        jndiProps.put("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        jndiProps.put("java.naming.provider.url", "remote://localhost:4447");
        InitialContext ctx = new InitialContext(jndiProps);
        TestRemote testRemote = (TestRemote)ctx.lookup("test/TestRemoteInterfaceBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to RemoteNamingWithoutPrefix", (Object)testRemote.getGreeting("RemoteNamingWithoutPrefix"));
        testRemote = (TestRemote)ctx.lookup("java:ee-ear-ear/ee-ear-ejb/TestRemoteBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to RemoteNaming", (Object)testRemote.getGreeting("RemoteNaming"));
    }

    @Test
    public void canLookup_testFacadeBean_usingServiceLocatorBuilder() throws Exception {
        JndiServiceLocator loc = ServiceLocatorBuilder.buildRemote().remoteServer("localhost", 8080).appName("").moduleName("test").createServiceLocator();
        TestRemote testRemote = (TestRemote)loc.lookup("TestRemoteInterfaceBean!" + TestRemote.class.getName());
        Assert.assertEquals((Object)"TestRemoteBean says hello to ServiceLocatorBuilder", (Object)testRemote.getGreeting("ServiceLocatorBuilder"));
    }
}

