/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.ee.webtest;

import ch.inftec.ju.ee.webtest.WebTest;
import ch.inftec.ju.testing.db.DbTestAnnotationHandler;
import ch.inftec.ju.testing.db.JuTestEnv;
import ch.inftec.ju.testing.db.SeleniumDriverPolicy;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import ch.inftec.ju.util.TestUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverRule
implements TestRule {
    private static final String CHROME_DRIVER_EXE_PROPERTY = "ju-testing-ee.selenium.chrome.chromeDriverExe";
    private static final String PHANTOM_JS_DRIVER_EXE_PROPERTY = "ju-testing-ee.selenium.phantomjs.phantomJsDriverExe";
    private static final String PROP_DRIVER = "ju-testing-ee.selenium.driver";
    private static final Logger logger = LoggerFactory.getLogger(DriverRule.class);
    private final WebTest testClass;
    private static String specifiedDrivers = null;
    private static List<DriverHandler> driverHandlers = new ArrayList<DriverHandler>();

    DriverRule(WebTest testClass) {
        this.testClass = testClass;
    }

    public Statement apply(final Statement base, Description description) {
        Method method = TestUtils.getTestMethod((Description)description);
        List testEnvAnnos = ReflectUtils.getAnnotationsWithInfo((Method)method, JuTestEnv.class, (boolean)false, (boolean)true, (boolean)true);
        List selPolicy = ReflectUtils.getAnnotationsWithInfo((Method)method, SeleniumDriverPolicy.class, (boolean)false, (boolean)true, (boolean)true);
        ArrayList seleniumDriverPolicyStringList = Lists.newArrayList();
        if (selPolicy != null && !selPolicy.isEmpty()) {
            Object[] seleniumPolicy = ((SeleniumDriverPolicy)((ReflectUtils.AnnotationInfo)selPolicy.get(0)).getAnnotation()).value();
            logger.debug("SeleniumDriverPolicy found: [" + Joiner.on((String)",").join(seleniumPolicy) + "]");
            for (Object seleniumDriver : seleniumPolicy) {
                seleniumDriverPolicyStringList.add(seleniumDriver.name());
            }
        } else {
            logger.trace("No SeleniumDriverPolicy to apply");
        }
        Collections.reverse(testEnvAnnos);
        final SystemPropertyTempSetter tempSetter = DbTestAnnotationHandler.setTestEnvProperties((List)testEnvAnnos);
        try {
            Object[] drivers;
            PropertyChain pc = JuUtils.getJuPropertyChain();
            String currentSpecifiedDriversBeforePolicy = pc.get(PROP_DRIVER, true);
            String currentSpecifiedDrivers = null;
            if (!seleniumDriverPolicyStringList.isEmpty()) {
                drivers = JuStringUtils.split((String)currentSpecifiedDriversBeforePolicy, (String)",", (boolean)true);
                ArrayList cleanedDriverList = Lists.newArrayList();
                Object[] objectArray = drivers;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    String driver = objectArray[i];
                    if (seleniumDriverPolicyStringList.contains(driver)) {
                        cleanedDriverList.add(driver);
                        continue;
                    }
                    logger.debug("Removed the driver '" + driver + "' from the driver list, as it not part of the set SeleniumDriverPolicy");
                }
                if (cleanedDriverList.isEmpty()) {
                    cleanedDriverList.add(seleniumDriverPolicyStringList.get(0));
                }
                currentSpecifiedDrivers = Joiner.on((String)",").join((Iterable)cleanedDriverList);
            } else {
                currentSpecifiedDrivers = currentSpecifiedDriversBeforePolicy;
            }
            if (driverHandlers.isEmpty() || !StringUtils.equals((CharSequence)specifiedDrivers, (CharSequence)currentSpecifiedDrivers)) {
                specifiedDrivers = currentSpecifiedDrivers;
                DriverRule.closeAll();
                drivers = JuStringUtils.split((String)specifiedDrivers, (String)",", (boolean)true);
                Assert.assertTrue((String)String.format("No drivers specified, please check '%s' and the SeleniumDriverPolicy for the JUnit test", PROP_DRIVER), (drivers.length > 0 ? 1 : 0) != 0);
                logger.debug("Initialize WebDrivers: " + Arrays.toString(drivers));
                for (Object driverType : drivers) {
                    logger.debug("Creating driver: " + (String)driverType);
                    if (SeleniumDriverPolicy.SeleniumDriver.HtmlUnit.name().equals(driverType)) {
                        driverHandlers.add(new HtmlUnitDriverHandler());
                        continue;
                    }
                    if (SeleniumDriverPolicy.SeleniumDriver.Chrome.name().equals(driverType)) {
                        driverHandlers.add(new ChromeDriverHandler());
                        continue;
                    }
                    if (SeleniumDriverPolicy.SeleniumDriver.PhantomJS.name().equals(driverType)) {
                        driverHandlers.add(new PhantomJSDriverHandler());
                        continue;
                    }
                    throw new JuRuntimeException(String.format("Unsupported selenium driver type: %s. Check value of property %s", driverType, PROP_DRIVER));
                }
            }
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    try {
                        for (int i = 0; i < driverHandlers.size(); ++i) {
                            DriverHandler driverHandler = (DriverHandler)driverHandlers.get(i);
                            try (DriverHandler.DriverHandlerCreator driverCreator = driverHandler.newDriverHandlerCreator();){
                                logger.info("Running test with WebDriver " + driverCreator);
                                ((DriverRule)DriverRule.this).testClass.driver = driverCreator.getDriver();
                                base.evaluate();
                                continue;
                            }
                        }
                    }
                    finally {
                        tempSetter.close();
                    }
                }
            };
        }
        catch (Exception ex) {
            tempSetter.close();
            throw ex;
        }
    }

    public static void closeAll() {
        driverHandlers.clear();
    }

    private static Path getDriverExePath(String propertyName) {
        String propertiesDriverPathString = JuUtils.getJuPropertyChain().get(propertyName);
        if (!StringUtils.isEmpty((CharSequence)propertiesDriverPathString)) {
            Path juDriverExePath = Paths.get(propertiesDriverPathString, new String[0]);
            logger.debug("Using the path '" + juDriverExePath + "' from JU settings for: " + propertyName);
            return juDriverExePath;
        }
        throw new JuRuntimeException("The property '" + propertyName + "' (path to the executable') is not set");
    }

    public static class PhantomJSDriverHandler
    extends DriverHandler {
        @Override
        protected WebDriver createWebDriver() {
            DesiredCapabilities cap = DesiredCapabilities.phantomjs();
            String proxyServer = this.getProxyServer();
            if (proxyServer != null) {
                ArrayList<String> cliArgsCap = new ArrayList<String>();
                cliArgsCap.add("--proxy=" + proxyServer + ":8080");
                cliArgsCap.add("--proxy-type=http");
                cap.setCapability("phantomjs.cli.args", cliArgsCap);
            }
            String phantomJSExePath = DriverRule.getDriverExePath(DriverRule.PHANTOM_JS_DRIVER_EXE_PROPERTY).toAbsolutePath().toString();
            cap.setCapability("phantomjs.binary.path", phantomJSExePath);
            return new PhantomJSDriver((Capabilities)cap);
        }
    }

    public static class ChromeDriverHandler
    extends DriverHandler {
        @Override
        protected WebDriver createWebDriver() {
            System.setProperty("webdriver.chrome.driver", DriverRule.getDriverExePath(DriverRule.CHROME_DRIVER_EXE_PROPERTY).toAbsolutePath().toString());
            DesiredCapabilities cap = DesiredCapabilities.chrome();
            String proxyServer = this.getProxyServer();
            if (proxyServer != null) {
                cap.setCapability("chrome.switches", Arrays.asList(String.format("--proxy-server=%s", proxyServer)));
            }
            return new ChromeDriver((Capabilities)cap);
        }
    }

    public static class HtmlUnitDriverHandler
    extends DriverHandler {
        @Override
        protected WebDriver createWebDriver() {
            DesiredCapabilities cap = DesiredCapabilities.htmlUnit();
            String proxyServer = this.getProxyServer();
            if (proxyServer != null) {
                Proxy proxy = new Proxy();
                proxy.setHttpProxy(proxyServer);
                cap.setCapability("proxy", (Object)proxy);
            }
            boolean enableJavaScript = (Boolean)this.pc.get("ju-testing-ee.selenium.htmlUnit.enableJavascript", Boolean.class);
            cap.setJavascriptEnabled(enableJavaScript);
            return new HtmlUnitDriver((Capabilities)cap);
        }
    }

    private static abstract class DriverHandler {
        protected final PropertyChain pc = JuUtils.getJuPropertyChain();

        private DriverHandler() {
        }

        public DriverHandlerCreator newDriverHandlerCreator() {
            return new DriverHandlerCreator();
        }

        protected final String getProxyServer() {
            String proxyServer = this.pc.get("ju-testing-ee.internet.proxy");
            return StringUtils.isEmpty((CharSequence)proxyServer) ? null : proxyServer;
        }

        protected abstract WebDriver createWebDriver();

        private class DriverHandlerCreator
        implements AutoCloseable {
            private final WebDriver driver;

            public DriverHandlerCreator() {
                this.driver = DriverHandler.this.createWebDriver();
            }

            public WebDriver getDriver() {
                return this.driver;
            }

            @Override
            public void close() throws Exception {
                logger.debug("Closing WebDriver " + this.toString());
                this.driver.quit();
            }

            public String toString() {
                return String.format("%s [WebDriver: %s]", DriverHandler.this.getClass().getSimpleName(), this.driver);
            }
        }
    }
}

