/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.devops;

import ch.inftec.ju.devops.AuthorizedFilesNameFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class FilesystemCleanup {
    private static final Logger logger = Logger.getLogger(FilesystemCleanup.class);
    public static final int OLDER_THAN = 10;
    public static final int MAX_RELEASES = 15;
    public static final int MIN_RELEASES = 5;
    private boolean dryRun = true;

    public FilesystemCleanup() {
        this(false);
    }

    public FilesystemCleanup(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public int cleanup(File directory) {
        return this.cleanup(directory, 10, 15, 5);
    }

    public int cleanup(File directory, int olderThan, int keepMaxReleases, int keepMinReleases) {
        File file;
        if (!directory.isDirectory()) {
            throw new RuntimeException(String.format("path %s is not a directory", directory.getAbsolutePath()));
        }
        File cleanupAuthorisationFile = new File(directory, ".cleanup-authorisation");
        if (!cleanupAuthorisationFile.exists()) {
            throw new RuntimeException(String.format("directory %s must contain a file named .cleanup-authorisation, otherwise a cleanup is not possible", directory.getAbsolutePath()));
        }
        logger.info((Object)String.format("cleanup directory %s (olderThan %d days, keepMaxReleases %d, keepMinReleases %d)", directory.getPath(), olderThan, keepMaxReleases, keepMinReleases));
        File[] files = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(cleanupAuthorisationFile));
            ArrayList<String> filenamePatterns = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                filenamePatterns.add(line);
                line = reader.readLine();
            }
            files = directory.listFiles(new AuthorizedFilesNameFilter(filenamePatterns.toArray(new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("directory %s must contain a file named .cleanup-authorisation, otherwise a cleanup is not possible", directory.getAbsolutePath()));
        }
        logger.info((Object)String.format("found %d files to process", files.length));
        if (files.length <= keepMinReleases) {
            logger.info((Object)String.format("number of releases don't reach the keepMinReleases (=%d) value, no releases are deleted", files.length));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("repodir: %s, number of files: %d", directory.getPath(), files.length));
            }
            return 0;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(5, cal.get(5) - olderThan);
        Date limit = new Date(cal.getTimeInMillis());
        TreeSet<File> sortedFiles = new TreeSet<File>(new ModifiedFileComparator());
        ArrayList<File> filesToRemove = new ArrayList<File>();
        sortedFiles.addAll(Arrays.asList(files));
        logger.info((Object)String.format("sorted %d files to process", sortedFiles.size()));
        Iterator fileIt = sortedFiles.iterator();
        while (fileIt.hasNext()) {
            file = (File)fileIt.next();
            Date modifDate = new Date(file.lastModified());
            if (modifDate.before(limit)) {
                if (sortedFiles.size() <= keepMinReleases) {
                    logger.info((Object)String.format("%s not removed (%s, keep min releases)", file.getName(), modifDate.toString()));
                    continue;
                }
                logger.debug((Object)String.format("%s will be removed (%s)", file.getName(), modifDate.toString()));
                filesToRemove.add(file);
                fileIt.remove();
                continue;
            }
            logger.info((Object)String.format("%s not removed (%s, keep because of time))", file.getName(), modifDate.toString()));
        }
        fileIt = sortedFiles.iterator();
        while (sortedFiles.size() > keepMaxReleases) {
            file = (File)fileIt.next();
            logger.debug((Object)String.format("%s to be removed (%s, above quota)", file.getName(), new Date(file.lastModified()).toString()));
            filesToRemove.add(file);
            fileIt.remove();
        }
        for (File fileToRemove : filesToRemove) {
            String message = String.format("%s removed (%s)", fileToRemove.getName(), new Date(fileToRemove.lastModified()));
            if (!this.dryRun) {
                this.removeDirectory(fileToRemove);
                logger.info((Object)message);
                continue;
            }
            logger.info((Object)String.format("dryRun - %s", message));
        }
        if (!this.dryRun) {
            logger.info((Object)String.format("%d files removed, %d files kept", filesToRemove.size(), sortedFiles.size()));
        } else {
            logger.info((Object)String.format("%d files removed (dryRun), %d files kept", filesToRemove.size(), sortedFiles.size()));
        }
        return filesToRemove.size();
    }

    public void removeDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new RuntimeException(String.format("file path %s is not a directory", directory.getAbsolutePath()));
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.removeDirectory(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    public static void main(String[] args) throws FileNotFoundException {
        File directory = new File(System.getProperty("directory"));
        if (!directory.isDirectory()) {
            throw new FileNotFoundException(String.format("directory %s does not exist", System.getProperty("directory")));
        }
        boolean dryRun = Boolean.parseBoolean(System.getProperty("dryRun", "true"));
        int olderThan = Integer.parseInt(System.getProperty("olderThan", "10"));
        int keepMaxFiles = Integer.parseInt(System.getProperty("keepMax", "15"));
        int keepMinFiles = Integer.parseInt(System.getProperty("keepMin", "5"));
        FilesystemCleanup cleanup = new FilesystemCleanup(dryRun);
        logger.info((Object)String.format("start cleaning from %s", directory.getPath()));
        int result = cleanup.cleanup(directory, olderThan, keepMaxFiles, keepMinFiles);
        logger.info((Object)String.format("cleaned %d directories from %s", result, directory.getPath()));
    }

    public static class ModifiedFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            Date modifDate1 = new Date(o1.lastModified());
            Date modifDate2 = new Date(o2.lastModified());
            logger.trace((Object)String.format("%s %s - %s %s", o1.getName(), modifDate1.toString(), o2.getName(), modifDate2.toString()));
            int result = modifDate1.compareTo(modifDate2);
            if (result == 0) {
                return -1;
            }
            return result;
        }
    }
}

