/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.devops;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class AuthorizedFilesNameFilter
implements FilenameFilter {
    private static final Logger logger = Logger.getLogger(AuthorizedFilesNameFilter.class);
    private String[] includeFilenamePatterns = new String[]{"-S-"};

    public AuthorizedFilesNameFilter() {
        logger.debug((Object)String.format("using default filter: %s", this.includeFilenamePatterns));
    }

    public AuthorizedFilesNameFilter(String ... includeFilenamePatterns) {
        this.includeFilenamePatterns = includeFilenamePatterns;
        logger.debug((Object)String.format("custom filter from .cleanup-authorisation: %s", Arrays.asList(this.includeFilenamePatterns)));
    }

    @Override
    public boolean accept(File dir, String name) {
        for (String each : this.includeFilenamePatterns) {
            if (!name.contains(each)) continue;
            return true;
        }
        logger.debug((Object)String.format("file filtered out: %s", name));
        return false;
    }
}

