/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.devops;

import ch.inftec.ju.devops.AuthorizedFilesNameFilter;
import ch.inftec.ju.devops.FilesystemCleanup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilesystemCleanupTest {
    Logger logger = Logger.getLogger(FilesystemCleanupTest.class);
    private static File baseDir = new File("target", "maven-repo");
    private static File repoDir;
    private final String[] filenamePatterns = new String[]{"-S-", "-custom-"};

    private void cleanup() {
    }

    @Before
    public void setUp() throws Exception {
        baseDir.mkdir();
    }

    private void createDefaultTestSet(boolean createCleanupAuthFile) throws IOException {
        long now = System.currentTimeMillis() - 3600000L;
        this.createDefaultTestSet(30, createCleanupAuthFile, now);
    }

    private void createDefaultTestSet(int numbOfReleases, boolean createCleanupAuthFile, long now) throws IOException {
        repoDir.mkdir();
        if (createCleanupAuthFile) {
            this.createCleanupAuthorisationFile();
        }
        int i = 0;
        int j = numbOfReleases;
        while (i < numbOfReleases) {
            long modTime = now - (long)i * 24L * 60L * 60L * 1000L;
            this.logger.trace((Object)String.format("%s", new Date(modTime).toString()));
            this.createRelease("0.5-RC-" + j, modTime);
            if (i % 2 == 0) {
                this.createRelease("0.6-S-" + j, modTime);
            } else {
                this.createRelease("0.6-custom-" + j, modTime);
            }
            ++i;
            --j;
        }
    }

    private void create2ReleasesTestSet() throws IOException {
        long now = System.currentTimeMillis() - 3600000L;
        this.createDefaultTestSet(2, true, now);
    }

    private void create2VeryOldReleasesTestSet() throws IOException {
        long now = System.currentTimeMillis() - 25032704L;
        this.createDefaultTestSet(2, true, now);
    }

    private void createOnly4youngerThanReleasesTestSet() throws IOException {
        repoDir.mkdir();
        this.createCleanupAuthorisationFile();
        long now = System.currentTimeMillis() - 3600000L;
        int i = 0;
        int j = 40;
        while (i < 4) {
            long modTime = now - (long)i * 24L * 60L * 60L * 1000L;
            this.logger.trace((Object)String.format("%s", new Date(modTime).toString()));
            this.createRelease("0.5-RC-" + j, modTime);
            if (i % 2 == 0) {
                this.createRelease("0.6-S-" + j, modTime);
            } else {
                this.createRelease("0.6-custom-" + j, modTime);
            }
            ++i;
            --j;
        }
        long twelveDaysAgo = System.currentTimeMillis() - 1036800000L;
        int i2 = 4;
        int j2 = 36;
        while (i2 < 40) {
            long modTime = twelveDaysAgo - (long)i2 * 24L * 60L * 60L * 1000L;
            this.logger.trace((Object)String.format("%s", new Date(modTime).toString()));
            this.createRelease("0.5-RC-" + j2, modTime);
            if (i2 % 2 == 0) {
                this.createRelease("0.6-S-" + j2, modTime);
            } else {
                this.createRelease("0.6-custom-" + j2, modTime);
            }
            ++i2;
            --j2;
        }
        Assert.assertEquals((long)40L, (long)this.countFiles());
    }

    private void create30youngerThanReleasesTestSet() throws IOException {
        repoDir.mkdir();
        this.createCleanupAuthorisationFile();
        long now = System.currentTimeMillis() - 3600000L;
        int i = 0;
        int j = 40;
        while (i < 30) {
            long modTime = now - (long)i * 6L * 60L * 60L * 1000L;
            this.logger.trace((Object)String.format("%s", new Date(modTime).toString()));
            this.createRelease("0.5-RC-" + j, modTime);
            if (i % 2 == 0) {
                this.createRelease("0.6-S-" + j, modTime);
            } else {
                this.createRelease("0.6-custom-" + j, modTime);
            }
            ++i;
            --j;
        }
        long twelveDaysAgo = System.currentTimeMillis() - 1036800000L;
        int i2 = 30;
        int j2 = 10;
        while (i2 < 40) {
            long modTime = twelveDaysAgo - (long)i2 * 24L * 60L * 60L * 1000L;
            this.logger.trace((Object)String.format("%s", new Date(modTime).toString()));
            this.createRelease("0.5-RC-" + j2, modTime);
            if (i2 % 2 == 0) {
                this.createRelease("0.6-S-" + j2, modTime);
            } else {
                this.createRelease("0.6-custom-" + j2, modTime);
            }
            ++i2;
            --j2;
        }
    }

    private void createRelease(String version, long modTime) throws IOException {
        File dir1 = new File(repoDir, version);
        dir1.mkdir();
        this.createFileInDir(dir1, "test-artifact-" + version + ".pom", modTime);
        dir1.setLastModified(modTime);
    }

    private void createFileInDir(File dir, String name, long modTime) throws IOException {
        File file = new File(dir, name);
        file.createNewFile();
        file.setLastModified(modTime);
    }

    @After
    public void tearDown() throws Exception {
        this.cleanup();
    }

    @Test
    public void testNonDirectoryCleanup() {
        this.logger.debug((Object)String.format("%s", "testNonDirectoryCleanup"));
        repoDir = new File(baseDir, "testNonDirectoryCleanup");
        try {
            this.createDefaultTestSet(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            cleanup.cleanup(new File(repoDir + "/.cleanup-authorisation"));
            Assert.fail((String)"should throw an illegal argument exception, as only directories can be cleaned");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testUnauthorizedCleanup() {
        this.logger.debug((Object)String.format("%s", "testUnauthorizedCleanup"));
        repoDir = new File(baseDir, "testUnauthorizedCleanup");
        try {
            this.createDefaultTestSet(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        FilesystemCleanup cleanup = new FilesystemCleanup();
        int result = -1;
        try {
            result = cleanup.cleanup(repoDir);
            Assert.fail((String)"");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)-1L, (long)result);
        }
    }

    @Test
    public void testCleanupWithNonMatchingPatterns() {
        this.logger.debug((Object)String.format("%s", "testUnauthorizedCleanup"));
        repoDir = new File(baseDir, "testUnauthorizedCleanup");
        try {
            this.createDefaultTestSet(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        FilesystemCleanup cleanup = new FilesystemCleanup();
        int result = -1;
        try {
            result = cleanup.cleanup(repoDir);
            Assert.fail((String)"");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)-1L, (long)result);
        }
    }

    @Test
    public void testDefaultCleanup() {
        this.logger.debug((Object)String.format("%s", "testDefaultCleanup"));
        repoDir = new File(baseDir, "testDefaultCleanup");
        try {
            this.createDefaultTestSet(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            int result = cleanup.cleanup(repoDir);
            Assert.assertEquals((long)20L, (long)result);
            Assert.assertEquals((long)10L, (long)this.countFiles());
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDefaultKeepMaxReleasesCleanup() {
        this.logger.debug((Object)String.format("%s", "testDefaultKeepMaxReleasesCleanup"));
        repoDir = new File(baseDir, "testDefaultKeepMaxReleasesCleanup");
        try {
            this.create30youngerThanReleasesTestSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            int result = cleanup.cleanup(repoDir);
            Assert.assertEquals((long)25L, (long)result);
            Assert.assertEquals((long)15L, (long)this.countFiles());
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDefaultKeepMinReleasesCleanup() {
        this.logger.debug((Object)String.format("%s", "testDefaultKeepMinReleasesCleanup"));
        repoDir = new File(baseDir, "testDefaultKeepMinReleasesCleanup");
        try {
            this.create2ReleasesTestSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            int result = cleanup.cleanup(repoDir);
            Assert.assertEquals((long)0L, (long)result);
            Assert.assertEquals((long)2L, (long)this.countFiles());
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDefaultKeepMin2ReleasesCleanup() {
        this.logger.debug((Object)String.format("%s", "testDefaultKeepMin2ReleasesCleanup"));
        repoDir = new File(baseDir, "testDefaultKeepMin2ReleasesCleanup");
        try {
            this.createOnly4youngerThanReleasesTestSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            int result = cleanup.cleanup(repoDir);
            Assert.assertEquals((long)35L, (long)result);
            Assert.assertEquals((long)5L, (long)this.countFiles());
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDefaultKeepMin3ReleasesCleanup() {
        this.logger.debug((Object)String.format("%s", "testDefaultKeepMin3ReleasesCleanup"));
        repoDir = new File(baseDir, "testDefaultKeepMin3ReleasesCleanup");
        try {
            this.create2VeryOldReleasesTestSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            int result = cleanup.cleanup(repoDir);
            Assert.assertEquals((long)0L, (long)result);
            Assert.assertEquals((long)2L, (long)this.countFiles());
        }
        catch (RuntimeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLightweightReleaseNameFilter() {
        this.logger.debug((Object)String.format("%s", "testLightweightReleaseNameFilter"));
        repoDir = new File(baseDir, "testLightweightReleaseNameFilter");
        try {
            this.createDefaultTestSet(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup cleanup = new FilesystemCleanup();
            Assert.assertEquals((long)30L, (long)this.countFiles());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMain() {
        this.logger.debug((Object)String.format("%s", "testMain"));
        repoDir = new File(baseDir, "testMain");
        try {
            this.createDefaultTestSet(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        System.setProperty("directory", repoDir.getAbsolutePath());
        System.setProperty("dryRun", "false");
        try {
            FilesystemCleanup.main((String[])new String[0]);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMainWithoutSetDirectory() {
        this.logger.debug((Object)String.format("%s", "testMainWithoutSetDirectory"));
        repoDir = new File(baseDir, "testMainWithoutSetDirectory");
        System.setProperty("dryRun", "false");
        try {
            this.createDefaultTestSet(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        try {
            FilesystemCleanup.main((String[])new String[0]);
            Assert.fail((String)"test should fail");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMainWithWrongDirectorySet() {
        this.logger.debug((Object)String.format("%s", "testMainWithWrongDirectorySet"));
        repoDir = new File(baseDir, "testMainWithWrongDirectorySet");
        try {
            this.createDefaultTestSet(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Not yet implemented");
        }
        System.setProperty("directory", "foobar");
        System.setProperty("dryRun", "false");
        try {
            FilesystemCleanup.main((String[])new String[0]);
            Assert.fail((String)"test should fail");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private int countFiles() {
        return repoDir.listFiles((FilenameFilter)new AuthorizedFilesNameFilter(this.filenamePatterns)).length;
    }

    private void createCleanupAuthorisationFile() throws IOException {
        File file = new File(repoDir, ".cleanup-authorisation");
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        for (String each : this.filenamePatterns) {
            writer.println(each);
        }
        writer.flush();
        writer.close();
    }
}

