/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.auth;

import ch.inftec.ju.db.auth.AuthenticationEditorModel;
import ch.inftec.ju.db.auth.UnknownUserHandler;
import ch.inftec.ju.db.auth.entity.AuthRole;
import ch.inftec.ju.db.auth.entity.AuthUser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.TransactionException;

public class JuUserDetailsService
implements UserDetailsService {
    private Logger logger = LoggerFactory.getLogger(JuUserDetailsService.class);
    @Autowired(required=false)
    private UnknownUserHandler unknownUserHandler;
    @Autowired
    private AuthenticationEditorModel authenticationEditorModel;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        AuthUser authUser = null;
        boolean noDbConn = false;
        try {
            authUser = this.authenticationEditorModel.getUser(username);
        }
        catch (TransactionException ex) {
            this.logger.warn(String.format("Couldn't get authentication info for user %s from DB", username), (Throwable)ex);
            noDbConn = true;
        }
        if (authUser == null) {
            UnknownUserHandler.NewUserInfo newUserInfo;
            if (this.unknownUserHandler != null && (newUserInfo = this.unknownUserHandler.handleUser(username)) != null) {
                if (!noDbConn) {
                    authUser = this.authenticationEditorModel.addUser(username, newUserInfo.getPassword(), newUserInfo.getAuthorities());
                } else {
                    newUserInfo.getAuthorities();
                    ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
                    for (String role : newUserInfo.getAuthorities()) {
                        grantedAuths.add(new SimpleGrantedAuthority(role));
                    }
                    return new User(username, newUserInfo.getPassword(), grantedAuths);
                }
            }
            if (authUser == null) {
                throw new UsernameNotFoundException("No such user: " + username);
            }
        } else {
            this.authenticationEditorModel.updateLoginCount(authUser);
        }
        ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
        for (AuthRole authRole : authUser.getRoles()) {
            grantedAuths.add(new SimpleGrantedAuthority(authRole.getName()));
        }
        User user = new User(username, authUser.getPassword(), grantedAuths);
        return user;
    }
}

