/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSchemaBuilder;
import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.ConversionUtils;
import ch.inftec.ju.util.XString;
import java.sql.Connection;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSpecificHandlerOracle
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerOracle(JuConnUtil connUtil) {
        super(connUtil);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.queryForList("select SEQUENCE_NAME from USER_SEQUENCES", String.class);
    }

    @Override
    public void resetIdentityGenerationOrSequences(final int val) {
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                for (String sequence : DbSpecificHandlerOracle.this.getSequenceNames()) {
                    jt.execute("drop sequence " + sequence);
                    jt.execute(String.format("create sequence %s start with %d", sequence, val));
                }
            }
        });
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.queryForObject(String.format("select %s.nextVal from dual", sequenceName), Object.class));
    }

    @Override
    public void createSchema(final DbSchemaBuilder builder) {
        AssertUtil.assertNotEmpty((String)"Schema name is required", (String)builder.getName());
        AssertUtil.assertNotEmpty((String)"Schema password is required", (String)builder.getPassword());
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                String tableSpace = "USERS";
                XString xs = new XString();
                xs.addFormatted("CREATE USER %s IDENTIFIED BY %s", new Object[]{builder.getName(), builder.getPassword()});
                xs.addFormatted(" DEFAULT TABLESPACE %s", new Object[]{tableSpace});
                xs.addFormatted(" QUOTA UNLIMITED ON %s", new Object[]{tableSpace});
                jt.execute(xs.toString());
                if (builder.isDefaultGrants()) {
                    jt.execute(String.format("GRANT CREATE SESSION TO %s", builder.getName()));
                    jt.execute(String.format("GRANT CREATE TABLE TO %s", builder.getName()));
                    jt.execute(String.format("GRANT CREATE VIEW TO %s", builder.getName()));
                    jt.execute(String.format("GRANT CREATE ANY TRIGGER TO %s", builder.getName()));
                    jt.execute(String.format("GRANT CREATE ANY PROCEDURE TO %s", builder.getName()));
                    jt.execute(String.format("GRANT CREATE SEQUENCE TO %s", builder.getName()));
                    jt.execute(String.format("GRANT CREATE SYNONYM TO %s", builder.getName()));
                }
                if (builder.isJtaRecoveryGrants()) {
                    jt.execute(String.format("GRANT SELECT ON SYS.DBA_PENDING_TRANSACTIONS TO %s", builder.getName()));
                    jt.execute(String.format("GRANT SELECT ON SYS.PENDING_TRANS$ TO %s", builder.getName()));
                    jt.execute(String.format("GRANT SELECT ON SYS.DBA_2PC_PENDING TO %s", builder.getName()));
                    jt.execute(String.format("GRANT EXECUTE ON SYS.DBMS_SYSTEM TO %s", builder.getName()));
                }
            }
        });
    }

    @Override
    public void dropSchema(final JuConnUtil.MetaDataInfo.SchemaInfo schemaInfo, String ... users) {
        AssertUtil.assertTrue((String)"Dropping of users not supported for Oracle", (users.length == 0 ? 1 : 0) != 0);
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                jt.execute(String.format("DROP USER %s CASCADE", schemaInfo.getName()));
            }
        });
    }
}

