/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.util.ConversionUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSpecificHandlerHsql
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerHsql(JuConnUtil connUtil) {
        super(connUtil);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.queryForList("select SEQUENCE_NAME name from INFORMATION_SCHEMA.SEQUENCES where SEQUENCE_NAME not in ('LOB_ID')", String.class);
    }

    @Override
    public void resetIdentityGenerationOrSequences(final int val) {
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                List res = jt.queryForList("select c.TABLE_NAME, c.COLUMN_NAME from information_schema.columns c where c.IDENTITY_GENERATION is not null");
                for (Map row : res) {
                    String tableName = row.get("TABLE_NAME").toString();
                    String columnName = row.get("COLUMN_NAME").toString();
                    DbSpecificHandlerHsql.this.logger.debug(String.format("Restarting ID column %s.%s with %d", tableName, columnName, val));
                    jt.execute(String.format("alter table %s alter column %s RESTART WITH %d", tableName, columnName, val));
                }
                for (String sequenceName : DbSpecificHandlerHsql.this.getSequenceNames()) {
                    DbSpecificHandlerHsql.this.logger.debug(String.format("Restarting sequence %s with %d", sequenceName, val));
                    jt.execute(String.format("alter sequence %s restart with %d increment by %d", sequenceName, val, 1));
                }
            }
        });
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.queryForObject(String.format("call NEXT VALUE FOR %s", sequenceName), Object.class));
    }
}

