/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.util.ConversionUtils;
import java.sql.Connection;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSpecificHandlerH2
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerH2(JuConnUtil connUtil) {
        super(connUtil);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.queryForList("select SEQUENCE_NAME name from INFORMATION_SCHEMA.SEQUENCES", String.class);
    }

    @Override
    public void resetIdentityGenerationOrSequences(final int val) {
        for (final String sequenceName : this.getSequenceNames()) {
            this.logger.debug(String.format("Restarting sequence %s with %d", sequenceName, val));
            this.connUtil.doWork(new DbWork(){

                @Override
                public void execute(Connection conn) {
                    JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                    jt.execute(String.format("alter sequence %s restart with %d increment by %d", sequenceName, val, 1));
                }
            });
        }
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.queryForObject(String.format("select NEXTVAL('%s')", sequenceName), Object.class));
    }
}

