/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbRowUtils;
import ch.inftec.ju.db.JuDbUtils;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.dbutils.ResultSetHandler;

class DbRowResultSetHandler
implements ResultSetHandler<DbRowUtils.DbRowsImpl> {
    DbRowResultSetHandler() {
    }

    public DbRowUtils.DbRowsImpl handle(ResultSet rs) throws SQLException {
        int i;
        DbRowUtils.DbRowBuilder rowBuilder;
        DbRowUtils.DbRowsImpl dbRows = new DbRowUtils.DbRowsImpl();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            if (rsmd == null) {
                rsmd = rs.getMetaData();
            }
            rowBuilder = DbRowUtils.newDbRow();
            for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                rowBuilder.addValue(rsmd.getColumnName(i), rsmd.getColumnType(i), this.processValue(rs.getObject(i)));
            }
            dbRows.addRow(rowBuilder.getRow());
        }
        if (dbRows.getRowCount() == 0) {
            rowBuilder = DbRowUtils.newDbRow();
            for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                rowBuilder.addValue(rsmd.getColumnName(i), rsmd.getColumnType(i), null);
            }
            dbRows.setBaseRow(rowBuilder.getRow());
        }
        return dbRows;
    }

    private Object processValue(Object obj) {
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            return JuDbUtils.getClobString(clob);
        }
        return obj;
    }
}

