/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.change;

import ch.inftec.ju.db.DbConnection;
import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.change.AbstractDbRowDbAction;
import ch.inftec.ju.util.change.DbAction;
import ch.inftec.ju.util.change.InsertDbRowDbAction;

class DeleteDbRowDbAction
extends AbstractDbRowDbAction {
    private static final String MEMENTO_TYPE_NAME = "Delete";

    DeleteDbRowDbAction(DbConnection dbConn, DbRow row, String tableName) {
        super(dbConn, row, tableName);
        for (int i = 0; i < this.getRow().getColumnCount(); ++i) {
            String columnName = this.getRow().getColumnName(i);
            this.setValue(columnName, null);
        }
    }

    @Override
    public void execute() {
        XString deleteQry = null;
        try {
            deleteQry = new XString("DELETE FROM " + this.getTableName() + " WHERE " + this.getPrimaryKeyValue().getColumnName() + "=?");
            int res = this.getDbConnection().getQueryRunner().update(deleteQry.toString(), this.getPrimaryKeyValue().getOriginalValue());
            if (res != 1) {
                throw new JuDbException("Execution of query returned " + res + ", expected 1: " + deleteQry);
            }
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Failed to execute delete: " + deleteQry, (Throwable)ex);
        }
    }

    @Override
    public DbAction createUndoAction() {
        InsertDbRowDbAction undoAction = new InsertDbRowDbAction(this.getDbConnection(), this.getRow(), this.getTableName());
        return undoAction;
    }
}

