/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.auth.entity;

import ch.inftec.ju.db.AbstractPersistenceObject;
import ch.inftec.ju.db.auth.entity.AuthRole;
import ch.inftec.ju.util.JuStringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class AuthUser
extends AbstractPersistenceObject
implements Comparable<AuthUser> {
    @Id
    @GeneratedValue
    private Long id;
    @Column(unique=true, nullable=false)
    private String name;
    private String password;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLogin;
    private Integer loginCount;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<AuthRole> roles = new HashSet<AuthRole>();

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public Integer getLoginCount() {
        return this.loginCount;
    }

    public void setLoginCount(Integer loginCount) {
        this.loginCount = loginCount;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<AuthRole> getRoles() {
        return new TreeSet<AuthRole>(this.roles);
    }

    public void addRole(AuthRole role) {
        this.roles.add(role);
        role.users.add(this);
    }

    public void removeRole(AuthRole role) {
        this.roles.remove(role);
        role.users.remove(this);
    }

    @Override
    public int compareTo(AuthUser o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return JuStringUtils.toString((Object)this, (Object[])new Object[]{"name", this.getName()});
    }
}

