/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.auth;

import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.db.auth.AuthDao;
import ch.inftec.ju.db.auth.RoleProvider;
import ch.inftec.ju.db.auth.entity.AuthRole;
import ch.inftec.ju.db.auth.entity.AuthUser;
import ch.inftec.ju.db.auth.repo.AuthUserRepo;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuRuntimeException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="transactionManagerJuAuth")
public class AuthenticationEditorModel {
    @PersistenceContext(unitName="juAuth")
    private EntityManager em;
    @Autowired
    private RoleProvider roleProvider;
    @Autowired
    private AuthUserRepo userRepo;
    @Autowired
    private AuthDao authDao;

    public List<AuthUser> getUsers() {
        return this.userRepo.findAll();
    }

    public void processUsers(UserCallback c) {
        for (AuthUser user : this.getUsers()) {
            c.process(user);
        }
    }

    public List<String> getUserNames() {
        return this.userRepo.findAllNames();
    }

    public AuthUser addUser(String userName, String password) {
        if (this.getUser(userName) != null) {
            throw new JuDbException("User already exists: " + userName);
        }
        if (password == null) {
            throw new JuRuntimeException("Password must not be null");
        }
        AuthUser newUser = new AuthUser();
        newUser.setName(userName);
        newUser.setPassword(password);
        newUser.setLoginCount(1);
        newUser.setLastLogin(new Date());
        this.userRepo.save(newUser);
        return newUser;
    }

    public void deleteUser(String userName) {
        AuthUser user = this.getUser(userName);
        if (user != null) {
            this.userRepo.delete(user);
        }
    }

    public AuthUser addUser(String userName, String password, List<String> roles) {
        AuthUser authUser = this.addUser(userName, password);
        this.setRoles(authUser, roles);
        return authUser;
    }

    public AuthUser getUser(String userName) {
        return this.userRepo.getByName(userName);
    }

    public List<String> getRoles(AuthUser user) {
        this.em.merge((Object)user);
        ArrayList<String> roles = new ArrayList<String>();
        for (AuthRole role : user.getRoles()) {
            roles.add(role.getName());
        }
        return roles;
    }

    public List<String> getAvailableRoles() {
        return this.roleProvider.getAvailableRoles();
    }

    public void setRoles(AuthUser user, List<String> roles) {
        this.em.merge((Object)user);
        List<String> currentRoles = this.getRoles(user);
        for (String role : JuCollectionUtils.emptyForNull(roles)) {
            if (currentRoles.contains(role)) {
                currentRoles.remove(role);
                continue;
            }
            this.authDao.addRole(user, role);
        }
        for (String role : JuCollectionUtils.emptyForNull(currentRoles)) {
            this.authDao.removeRole(user, role);
        }
    }

    public void updateLoginCount(AuthUser user) {
        user.setLastLogin(new Date());
        user.setLoginCount(user.getLoginCount() != null ? user.getLoginCount() + 1 : 1);
        this.userRepo.save(user);
    }

    public static interface UserCallback {
        public void process(AuthUser var1);
    }
}

